"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _checkableInput = require("../../__internal__/checkable-input/checkable-input.style");
var _fieldHelp = _interopRequireDefault(require("../../__internal__/field-help/field-help.style"));
var _hiddenCheckableInput = _interopRequireDefault(require("../../__internal__/checkable-input/hidden-checkable-input.style"));
var _checkableInputSvgWrapper = _interopRequireDefault(require("../../__internal__/checkable-input/checkable-input-svg-wrapper.style"));
var _label = _interopRequireWildcard(require("../../__internal__/label/label.style"));
var _validationIcon = _interopRequireDefault(require("../../__internal__/validations/validation-icon.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
box-shadow: 0 0 0 3px var(--colorsSemanticFocus500);
`;
const StyledCheckbox = _styledComponents.default.div`
  ${_styledSystem.margin}
  ${({
  disabled,
  error,
  warning,
  info,
  fieldHelpInline,
  labelSpacing,
  inputWidth,
  reverse,
  size,
  adaptiveSpacingSmallScreen,
  applyNewValidation
}) => (0, _styledComponents.css)`
    ${adaptiveSpacingSmallScreen && "margin-left: 0;"}

    ${_checkableInput.StyledCheckableInput} {
      padding-top: 1px;
    }

    ${_checkableInputSvgWrapper.default} {
      height: 16px;
    }

    svg {
      background-color: var(--colorsUtilityYang100);
      ${!disabled && (0, _styledComponents.css)`
        border: 1px solid var(--colorsUtilityMajor300);

        ${info && `border: 1px solid var(--colorsSemanticInfo500);`}
        ${warning && `border: 1px solid var(--colorsSemanticCaution500);`}
        ${error && `border: 2px solid var(--colorsSemanticNegative500);`}

        ${warning && applyNewValidation && `border: 1px solid var(--colorsUtilityMajor300);`}
      `}
    }

    ${_hiddenCheckableInput.default},
    svg {
      height: 16px;
      position: absolute;
      padding: 1px;
    }

    ${_checkableInput.StyledCheckableInput},
    ${_hiddenCheckableInput.default},
    ${_checkableInputSvgWrapper.default},
    svg {
      box-sizing: border-box;
      min-width: 16px;
      width: 16px;
      border-radius: var(--borderRadius025);
      ${size === "large" && `border-radius: var(--borderRadius050)`};
    }

    // prettier-ignore
    ${_hiddenCheckableInput.default}:not([disabled]) {
      ${({
  theme
}) => `
        &:focus + ${_checkableInputSvgWrapper.default} ,
        &:hover + ${_checkableInputSvgWrapper.default} {
          ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
        }
      `}
    }

    ${_label.StyledLabelContainer} {
      width: auto;
      flex: 0 1 auto;
    }

    ${_fieldHelp.default} {
      margin-left: 16px;
      margin-top: 0;
      padding-left: ${labelSpacing === 1 ? "var(--spacing100)" : "var(--spacing200)"};
    }

    ${_validationIcon.default} {
      position: relative;
      display: inline-block;
    }

    ${size === "large" && (0, _styledComponents.css)`
      ${_checkableInputSvgWrapper.default} {
        height: 24px;
      }

      ${_checkableInput.StyledCheckableInput},
      ${_hiddenCheckableInput.default},
      ${_checkableInputSvgWrapper.default},
      svg {
        height: 24px;
        width: 24px;
        min-width: 24px;
      }

      ${_fieldHelp.default} {
        margin-left: 24px;
        padding-left: ${labelSpacing === 1 ? "var(--spacing100)" : "var(--spacing200)"};
      }

      ${fieldHelpInline && (0, _styledComponents.css)`
        ${_fieldHelp.default}, ${_label.StyledLabelContainer} {
          align-self: center;
        }
      `}
    `}

    ${_hiddenCheckableInput.default}:checked ~ ${_checkableInputSvgWrapper.default} svg path {
      fill: var(--colorsUtilityYin090);
    }

    ${disabled && (0, _styledComponents.css)`
      svg {
        background-color: var(--colorsUtilityDisabled400);
        border: 1px solid var(--colorsUtilityDisabled600);
      }

      svg path {
        fill: var(--colorsUtilityDisabled400);
      }

      ${_hiddenCheckableInput.default}:checked ~ ${_checkableInputSvgWrapper.default} svg path {
        fill: var(--colorsUtilityYin030);
      }

      ${_checkableInputSvgWrapper.default} {
        &:hover,
        &:focus {
          outline: none;
          cursor: not-allowed;
        }
      }
    `}

    ${fieldHelpInline && `
      ${_fieldHelp.default} {
        margin-left: 0;
      }

      ${_label.default} {
        flex: 0 1 auto;
      }
    `}

    ${inputWidth !== undefined && inputWidth !== 0 && `
      ${_fieldHelp.default} {
        ${reverse ? "margin-right" : "margin-left"}: ${inputWidth}% !important;
      }
    `}

    ${reverse && (0, _styledComponents.css)`
      ${_fieldHelp.default} {
        margin-left: 0;
        padding-left: 0;
      }

      ${_label.default} {
        flex: 0 1 auto;
      }

      ${fieldHelpInline && (0, _styledComponents.css)`
        ${_checkableInput.StyledCheckableInput} {
          margin-right: 8px;
        }

        ${_fieldHelp.default} {
          padding-left: 6px;
        }
      `}
    `}
  `}
`;
StyledCheckbox.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledCheckbox;