"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledHintText = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _formField = _interopRequireDefault(require("../../../__internal__/form-field/form-field.style"));
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
var _checkbox = _interopRequireDefault(require("../checkbox.style"));
var _label = require("../../../__internal__/label/label.style");
var _validationIcon = _interopRequireDefault(require("../../../__internal__/validations/validation-icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledHintText = exports.StyledHintText = _styledComponents.default.div`
  margin-top: -4px;
  margin-bottom: 8px;
  color: var(--colorsUtilityYin055);
  font-size: 14px;
`;
const StyledCheckboxGroup = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  ${_icon.default}::before {
    font-size: 16px;
  }

  && ${_formField.default} {
    margin: 0;
  }

  & ${_checkbox.default} {
    margin-bottom: var(--spacing150);

    :last-of-type {
      margin-bottom: 0;
    }
  }

  & > ${_formField.default} {
    & > ${_label.StyledLabelContainer} {
      margin-bottom: 4px;
      vertical-align: middle;

      ${_validationIcon.default} {
        display: inline-block;
      }
    }
  }

  ${({
  legendInline
}) => legendInline && (0, _styledComponents.css)`
      ${_checkbox.default}:first-child {
        padding-top: 4px;
      }
    `}

  ${({
  inline
}) => inline && (0, _styledComponents.css)`
      flex-direction: row;
      ${_checkbox.default}:not(:first-of-type) {
        margin-left: 32px;
      }
    `}
`;
var _default = exports.default = StyledCheckboxGroup;