"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CheckboxGroupContext = exports.CheckboxGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
var _checkboxGroup = _interopRequireWildcard(require("./checkbox-group.style"));
var _fieldset = _interopRequireDefault(require("../../../__internal__/fieldset"));
var _utils = require("../../../style/utils");
var _tooltipProvider = require("../../../__internal__/tooltip-provider");
var _formSpacingProvider = _interopRequireDefault(require("../../../__internal__/form-spacing-provider"));
var _carbonProvider = require("../../carbon-provider/carbon-provider.component");
var _validationMessage = _interopRequireDefault(require("../../../__internal__/validation-message/validation-message.component"));
var _box = _interopRequireDefault(require("../../box"));
var _textbox = require("../../textbox/textbox.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const CheckboxGroupContext = exports.CheckboxGroupContext = /*#__PURE__*/_react.default.createContext({});
const CheckboxGroup = props => {
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const {
    children,
    legend,
    error,
    warning,
    info,
    required,
    isOptional,
    legendInline,
    legendWidth,
    legendAlign,
    legendSpacing,
    legendHelp,
    tooltipPosition,
    inline
  } = props;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, validationRedesignOptIn ? /*#__PURE__*/_react.default.createElement(_fieldset.default, _extends({
    legend: legend,
    inline: legendInline,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    error: error,
    warning: warning,
    info: info,
    isRequired: required,
    isOptional: isOptional
  }, (0, _tags.default)("checkboxgroup", props), {
    blockGroupBehaviour: !(error || warning)
  }, (0, _utils.filterStyledSystemMarginProps)(props)), legendHelp && /*#__PURE__*/_react.default.createElement(_checkboxGroup.StyledHintText, null, legendHelp), /*#__PURE__*/_react.default.createElement(_box.default, {
    position: "relative"
  }, /*#__PURE__*/_react.default.createElement(_validationMessage.default, {
    error: error,
    warning: warning
  }), (error || warning) && /*#__PURE__*/_react.default.createElement(_textbox.ErrorBorder, {
    warning: !!(!error && warning),
    inline: inline
  }), /*#__PURE__*/_react.default.createElement(_checkboxGroup.default, {
    "data-component": "checkbox-group",
    legendInline: legendInline,
    inline: inline
  }, /*#__PURE__*/_react.default.createElement(CheckboxGroupContext.Provider, {
    value: {
      error: !!error,
      warning: !!warning
    }
  }, /*#__PURE__*/_react.default.createElement(_formSpacingProvider.default, {
    marginBottom: undefined
  }, children))))) : /*#__PURE__*/_react.default.createElement(_tooltipProvider.TooltipProvider, {
    tooltipPosition: tooltipPosition
  }, /*#__PURE__*/_react.default.createElement(_fieldset.default, _extends({
    legend: legend,
    inline: legendInline,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    error: error,
    warning: warning,
    info: info,
    isRequired: required,
    isOptional: isOptional
  }, (0, _tags.default)("checkboxgroup", props), {
    blockGroupBehaviour: !(error || warning || info)
  }, (0, _utils.filterStyledSystemMarginProps)(props)), /*#__PURE__*/_react.default.createElement(_checkboxGroup.default, {
    "data-component": "checkbox-group",
    legendInline: legendInline
  }, /*#__PURE__*/_react.default.createElement(CheckboxGroupContext.Provider, {
    value: {
      error: !!error,
      warning: !!warning,
      info: !!info
    }
  }, /*#__PURE__*/_react.default.createElement(_formSpacingProvider.default, {
    marginBottom: undefined
  }, children))))));
};
exports.CheckboxGroup = CheckboxGroup;
CheckboxGroup.displayName = "CheckboxGroup";
var _default = exports.default = CheckboxGroup;