"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CarouselWrapperStyle = exports.CarouselStyledIconRight = exports.CarouselStyledIconLeft = exports.CarouselStyledIcon = exports.CarouselSliderWrapper = exports.CarouselSelectorWrapperStyle = exports.CarouselSelectorLabelStyle = exports.CarouselSelectorInputWrapperStyle = exports.CarouselSelectorInputStyle = exports.CarouselPreviousButtonWrapperStyle = exports.CarouselNextButtonWrapperStyle = exports.CarouselNavigationStyle = exports.CarouselButtonStyle = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _icon = _interopRequireDefault(require("../icon"));
var _slide = require("./slide.config");
var _slide2 = require("./slide/slide.style");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CarouselNavigationStyle = exports.CarouselNavigationStyle = _styledComponents.default.div`
  margin-top: -32.5px;
  position: absolute;
  top: 52%;
  z-index: 20;
`;
const CarouselPreviousButtonWrapperStyle = exports.CarouselPreviousButtonWrapperStyle = (0, _styledComponents.default)(CarouselNavigationStyle)`
  margin-left: 8px;
`;
const CarouselNextButtonWrapperStyle = exports.CarouselNextButtonWrapperStyle = (0, _styledComponents.default)(CarouselNavigationStyle)`
  right: 0;
  margin-right: 8px;
`;
const CarouselStyledIcon = exports.CarouselStyledIcon = (0, _styledComponents.default)(_icon.default)`
  cursor: pointer;
  color: var(--colorsActionMajorYang100);
  &::before {
    font-size: 16px;
  }
`;
const CarouselStyledIconLeft = exports.CarouselStyledIconLeft = (0, _styledComponents.default)(CarouselStyledIcon)`
  transform: rotate(90deg);
`;
const CarouselStyledIconRight = exports.CarouselStyledIconRight = (0, _styledComponents.default)(CarouselStyledIcon)`
  transform: rotate(-90deg);
`;
const oldFocusStyling = `
  outline: solid 2px var(--colorsSemanticFocus500);
`;
const CarouselButtonStyle = exports.CarouselButtonStyle = _styledComponents.default.button.attrs({
  type: "button"
})`
  ${({
  disabled
}) => (0, _styledComponents.css)`
    border: none;
    border-radius: var(--borderRadius400);
    width: 40px;
    height: 40px;
    border-width: var(--borderWidth200);
    border-color: var(--colorsActionMajorTransparent);
    background-color: ${disabled ? "var(--colorsActionDisabled500)" : "var(--colorsActionMajor500)"};

    ${disabled && (0, _styledComponents.css)`
      ${CarouselStyledIcon} {
        color: var(--colorsActionMajorYin030);
      }
    `}

    &:hover {
      background-color: var(--colorsActionMajor600);
      cursor: ${disabled ? "default" : "pointer"};

      ${disabled && (0, _styledComponents.css)`
        background-color: var(--colorsActionDisabled500);
        cursor: default;

        ${CarouselStyledIcon} {
          cursor: default;
        }
      `}
    }

    &:active {
      border: none;
    }

    &:focus {
      ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}

      ::-moz-focus-inner {
        border: 0;
      }

      ${disabled && (0, _styledComponents.css)`
        outline: none;
      `}
    }
  `}
`;
CarouselButtonStyle.defaultProps = {
  theme: _base.default
};
const CarouselSelectorInputStyle = exports.CarouselSelectorInputStyle = _styledComponents.default.input`
  display: none;
`;
const CarouselSelectorLabelStyle = exports.CarouselSelectorLabelStyle = _styledComponents.default.label`
  display: inline-block;
  border-radius: var(--borderRadius100);
  width: 10px;
  height: 10px;
  background: var(--colorsActionMinor200);
  margin: 0px 4px;

  &:hover {
    cursor: pointer;
  }
`;
const CarouselSelectorWrapperStyle = exports.CarouselSelectorWrapperStyle = _styledComponents.default.div`
  ${(0, _styledComponents.css)`
    height: 20px;
    margin-top: 25px;
    text-align: center;

    ${CarouselSelectorInputStyle}:checked {
      + ${CarouselSelectorLabelStyle} {
        width: 10px;
        height: 10px;
        background: var(--colorsActionMinor400);
        border-color: transparent;
        position: relative;
      }
    }
  `}
`;
const CarouselSelectorInputWrapperStyle = exports.CarouselSelectorInputWrapperStyle = _styledComponents.default.span`
  display: inline-block;
  line-height: 20px;
  vertical-align: middle;
`;
const CarouselSliderWrapper = exports.CarouselSliderWrapper = _styledComponents.default.div`
  transition: 0.4s;
  display: flex;
  position: relative;

  ${({
  elementIndex
}) => (0, _styledComponents.css)`
    left: ${10 - 80 * elementIndex}%;

    ${_slide2.SlideStyle}:nth-of-type(${elementIndex + 1}) {
      transform: scale(1);
      opacity: 1;
    }
  `}
`;
const CarouselWrapperStyle = exports.CarouselWrapperStyle = _styledComponents.default.div`
  .carbon-carousel__content {
    overflow: hidden;
    position: relative;
  }

  ${_slide.slideAnimation};
  ${_slide.fadeAnimation};
`;