"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Carousel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _carousel = require("./carousel.style");
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateWarnTriggered = false;
const NEXT = "next";
const PREVIOUS = "previous";
const Carousel = ({
  children,
  className,
  enableSlideSelector = true,
  enablePreviousButton = true,
  enableNextButton = true,
  initialSlideIndex = 0,
  onSlideChange,
  slideIndex,
  ...props
}) => {
  if (!deprecateWarnTriggered) {
    deprecateWarnTriggered = true;
    _logger.default.deprecate("The Carousel component is deprecated and will soon be removed.");
  }
  const [selectedSlideIndex, setSelectedSlideIndex] = (0, _react.useState)(Number(slideIndex) || Number(initialSlideIndex));
  const transitionDirection = (0, _react.useRef)(NEXT);
  const lastSlideIndexProp = (0, _react.useRef)(slideIndex);
  const id = (0, _react.useMemo)(() => (0, _guid.default)(), []);
  const numOfSlides = (0, _react.useMemo)(() => {
    return _react.default.Children.toArray(children).filter(child => /*#__PURE__*/_react.default.isValidElement(child)).length;
  }, [children]);
  const handleSlideChange = (0, _react.useCallback)(newIndex => {
    setSelectedSlideIndex(newIndex);
    if (onSlideChange) {
      onSlideChange(newIndex, transitionDirection.current);
    }
  }, [onSlideChange]);
  (0, _react.useEffect)(() => {
    const newIndex = slideIndex;
    const isNewIndexUndefined = typeof newIndex === "undefined";
    const isTheSameIndex = newIndex === lastSlideIndexProp.current || newIndex === selectedSlideIndex;
    if (isNewIndexUndefined || isTheSameIndex) return;
    if (Number(newIndex) > Number(selectedSlideIndex)) {
      transitionDirection.current = NEXT;
    } else {
      transitionDirection.current = PREVIOUS;
    }
    lastSlideIndexProp.current = newIndex;
    handleSlideChange(newIndex);
  }, [handleSlideChange, slideIndex, selectedSlideIndex]);
  function onPreviousClick() {
    const newIndex = selectedSlideIndex - 1;
    transitionDirection.current = PREVIOUS;
    handleSlideChange(newIndex);
  }
  function onNextClick() {
    const newIndex = selectedSlideIndex + 1;
    transitionDirection.current = NEXT;
    handleSlideChange(newIndex);
  }
  function onSlideSelection(ev) {
    const newSlideSelection = Number(ev.target.value);
    transitionDirection.current = newSlideSelection > selectedSlideIndex ? NEXT : PREVIOUS;
    handleSlideChange(newSlideSelection);
  }
  function slideSelector() {
    if (!enableSlideSelector) return null;
    const buttons = [];
    for (let i = 0; i < numOfSlides; i++) {
      buttons.push( /*#__PURE__*/_react.default.createElement(_carousel.CarouselSelectorInputWrapperStyle, {
        key: i,
        "data-element": "selector-inputs"
      }, /*#__PURE__*/_react.default.createElement(_carousel.CarouselSelectorInputStyle, {
        "data-element": "selector-input",
        name: `carousel-slide-${id}`,
        id: `carousel-slide-${i}-${id}`,
        type: "radio",
        value: i,
        onChange: onSlideSelection,
        checked: selectedSlideIndex === i
      }), /*#__PURE__*/_react.default.createElement(_carousel.CarouselSelectorLabelStyle, {
        "data-element": "selector-label",
        htmlFor: `carousel-slide-${i}-${id}`
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_carousel.CarouselSelectorWrapperStyle, {
      "data-element": "slide-selector"
    }, buttons);
  }
  function previousButton() {
    if (!enablePreviousButton) return null;
    const isDisabled = selectedSlideIndex === 0;
    return /*#__PURE__*/_react.default.createElement(_carousel.CarouselPreviousButtonWrapperStyle, null, /*#__PURE__*/_react.default.createElement(_carousel.CarouselButtonStyle, {
      onClick: onPreviousClick,
      "data-element": "previous",
      "aria-label": "previous",
      disabled: isDisabled
    }, /*#__PURE__*/_react.default.createElement(_carousel.CarouselStyledIconLeft, {
      type: "chevron_down"
    })));
  }
  function nextButton() {
    if (!enableNextButton) return null;
    const isDisabled = numOfSlides === selectedSlideIndex + 1;
    return /*#__PURE__*/_react.default.createElement(_carousel.CarouselNextButtonWrapperStyle, null, /*#__PURE__*/_react.default.createElement(_carousel.CarouselButtonStyle, {
      onClick: onNextClick,
      "data-element": "next",
      "aria-label": "next",
      type: "button",
      disabled: isDisabled
    }, /*#__PURE__*/_react.default.createElement(_carousel.CarouselStyledIconRight, {
      type: "chevron_down"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_carousel.CarouselWrapperStyle, _extends({
    className: className
  }, (0, _tags.default)("carousel", props)), /*#__PURE__*/_react.default.createElement("div", {
    className: "carbon-carousel__content"
  }, previousButton(), /*#__PURE__*/_react.default.createElement(_carousel.CarouselSliderWrapper, {
    elementIndex: selectedSlideIndex
  }, children), nextButton()), slideSelector());
};
exports.Carousel = Carousel;
Carousel.displayName = "Carousel";
var _default = exports.default = Carousel;