import React from "react";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
export interface CarouselProps extends TagProps {
    /** Individual tabs */
    children?: React.ReactNode;
    /** [legacy] Custom className */
    className?: string;
    /** Enables the next button */
    enableNextButton?: boolean;
    /** Enables the previous button */
    enablePreviousButton?: boolean;
    /** Enables the slide selector */
    enableSlideSelector?: boolean;
    /** The selected tab on page load */
    initialSlideIndex?: number | string;
    /** Action to be called on slide change */
    onSlideChange?: (index: number, transitionDirection: string) => void;
    /** The selected slide */
    slideIndex?: number | string;
}
export declare const Carousel: {
    ({ children, className, enableSlideSelector, enablePreviousButton, enableNextButton, initialSlideIndex, onSlideChange, slideIndex, ...props }: CarouselProps): React.JSX.Element;
    displayName: string;
};
export default Carousel;
