"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paddingSizes = exports.marginSizes = exports.StyledCardContent = exports.StyledCard = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const paddingSizes = exports.paddingSizes = {
  small: "0 var(--spacing300)",
  medium: "0 var(--spacing400)",
  large: "0 var(--spacing600)"
};
const marginSizes = exports.marginSizes = {
  small: "0 -24px",
  medium: "0 -32px",
  large: "0 -48px"
};
const StyledCard = exports.StyledCard = _styledComponents.default.div`
  ${({
  cardWidth,
  interactive,
  draggable,
  height,
  spacing,
  boxShadow = "boxShadow050",
  hoverBoxShadow = "boxShadow100",
  roundness
}) => (0, _styledComponents.css)`
    background-color: var(--colorsUtilityYang100);
    border: none;
    border-radius: ${roundness === "default" ? "var(--borderRadius100)" : "var(--borderRadius200)"};
    box-shadow: var(--${boxShadow});
    color: var(--colorsUtilityYin090);
    display: flex;
    flex-direction: column;
    height: ${height};
    justify-content: space-between;
    align-items: normal;
    margin: 25px;
    outline: none;
    padding: ${paddingSizes[spacing]};
    transition: all 0.3s ease-in-out;
    vertical-align: top;
    width: ${cardWidth};
    ${_styledSystem.margin}

    ${interactive && (0, _styledComponents.css)`
      :hover,
      :focus {
        box-shadow: var(--${hoverBoxShadow});
      }
    `}

    ${draggable && (0, _styledComponents.css)`
      cursor: move;
    `}

    ::-moz-focus-inner {
      border: 0;
    }
  `}
`;
const StyledCardContent = exports.StyledCardContent = _styledComponents.default.div.attrs(({
  href,
  onClick
}) => {
  if (href) {
    return {
      as: "a"
    };
  }
  if (onClick) {
    return {
      as: "button",
      role: "button",
      type: "button"
    };
  }
  return {};
})`
  ${({
  interactive,
  theme
}) => interactive && (0, _styledComponents.css)`
      cursor: pointer;

      ${!theme.focusRedesignOptOut && (0, _styledComponents.css)`
        :focus {
          ${(0, _addFocusStyling.default)()};
          position: relative;
        }
      `}
    `}

  outline: none;
  text-decoration: none;
  background-color: inherit;
  border: none;
  padding: 0;

  ${({
  spacing
}) => `
    padding: ${paddingSizes[spacing]};
    margin: ${marginSizes[spacing]};
  `}

  ${({
  roundness,
  hasFooter
}) => (0, _styledComponents.css)`
    ${roundness === "default" && (0, _styledComponents.css)`
      border-top-left-radius: var(--borderRadius100);
      border-top-right-radius: var(--borderRadius100);
      ${!hasFooter && (0, _styledComponents.css)`
        border-bottom-left-radius: var(--borderRadius100);
        border-bottom-right-radius: var(--borderRadius100);
      `}
    `}

    ${roundness !== "default" && (0, _styledComponents.css)`
      border-top-left-radius: var(--borderRadius200);
      border-top-right-radius: var(--borderRadius200);
      ${!hasFooter && (0, _styledComponents.css)`
        border-bottom-left-radius: var(--borderRadius200);
        border-bottom-right-radius: var(--borderRadius200);
      `}
    `}
  `}
`;
StyledCard.defaultProps = {
  theme: _base.default
};
StyledCardContent.defaultProps = {
  theme: _base.default
};