import { MarginProps } from "styled-system";
import * as DesignTokens from "@sage/design-tokens/js/base/common";
import { CardContextProps } from "./__internal__/card-context";
import { CardProps } from "./card.component";
export declare const paddingSizes: {
    small: string;
    medium: string;
    large: string;
};
export declare const marginSizes: {
    small: string;
    medium: string;
    large: string;
};
declare type DesignTokensType = keyof typeof DesignTokens;
export declare type BoxShadowsType = Extract<DesignTokensType, `boxShadow${string}`>;
export interface StyledCardProps extends MarginProps, Pick<CardContextProps, "roundness" | "spacing">, Pick<CardProps, "href" | "onClick"> {
    cardWidth: string;
    interactive: boolean;
    draggable: boolean;
    height?: string;
    boxShadow?: BoxShadowsType;
    hoverBoxShadow?: BoxShadowsType;
}
declare const StyledCard: import("styled-components").StyledComponent<"div", any, StyledCardProps, never>;
interface StyledCardContentProps extends Pick<CardContextProps, "roundness" | "spacing"> {
    interactive?: boolean;
    href?: string;
    hasFooter: boolean;
    target?: string;
    rel?: string;
}
declare const StyledCardContent: import("styled-components").StyledComponent<"div", any, ({
    as: string;
    role?: undefined;
    type?: undefined;
} | {
    as: string;
    role: "button";
    type: string;
} | {
    as?: undefined;
    role?: undefined;
    type?: undefined;
}) & StyledCardContentProps, "type" | "role" | "as">;
export { StyledCard, StyledCardContent };
