"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../../style/utils");
var _cardContext = _interopRequireDefault(require("./__internal__/card-context"));
var _card = require("./card.style");
var _icon = _interopRequireDefault(require("../icon"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Card = ({
  "data-element": dataElement,
  "data-role": dataRole,
  children,
  width = "500px",
  draggable,
  height,
  onClick,
  href,
  spacing = "medium",
  boxShadow,
  hoverBoxShadow,
  roundness = "default",
  footer,
  rel,
  target,
  "aria-label": ariaLabel,
  ...rest
}) => {
  const [contentRef, setContentRef] = (0, _react.useState)(null);
  const interactive = !!(onClick || href);
  let footerWarningFired = false;
  if (!footerWarningFired && interactive && contentRef?.querySelector("[data-component='card-footer']")) {
    footerWarningFired = true;
    // eslint-disable-next-line no-console
    console.warn("This `Card` is interactive you should use the `footer` prop to render a `CardFooter` to avoid potential accessibility issues");
  }
  return /*#__PURE__*/_react.default.createElement(_card.StyledCard, _extends({
    cardWidth: width,
    interactive: interactive,
    draggable: !!draggable,
    spacing: spacing,
    boxShadow: boxShadow,
    hoverBoxShadow: hoverBoxShadow,
    height: height,
    roundness: roundness
  }, (0, _utils.filterStyledSystemMarginProps)(rest), (0, _tags.default)("card", {
    "data-element": dataElement,
    "data-role": dataRole
  })), draggable && /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "drag"
  }), /*#__PURE__*/_react.default.createElement(_cardContext.default.Provider, {
    value: {
      roundness,
      spacing
    }
  }, /*#__PURE__*/_react.default.createElement(_card.StyledCardContent, {
    "data-element": "card-content-container",
    onClick: !draggable ? onClick : undefined,
    href: !draggable ? href : undefined,
    rel: !draggable && href ? rel : undefined,
    target: !draggable && href ? target : undefined,
    interactive: interactive,
    spacing: spacing,
    roundness: roundness,
    hasFooter: !!footer,
    ref: setContentRef,
    "aria-label": ariaLabel
  }, children), footer));
};
Card.displayName = "Card";
var _default = exports.default = Card;