"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _cardColumn = _interopRequireDefault(require("../card-column/card-column.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const marginSizes = {
  small: "0 -24px",
  medium: "0 -32px",
  large: "0 -48px"
};
const paddingSizes = {
  small: "16px 24px",
  medium: "18px 32px",
  large: "20px 48px"
};
const StyledCardFooter = _styledComponents.default.div`
  ${_styledSystem.space}

  ${({
  spacing,
  variant,
  roundness = "default"
}) => (0, _styledComponents.css)`
    background-color: ${variant === "transparent" ? "transparent" : "var(--colorsUtilityMajor025)"};
    border-top: var(--colorsUtilityMajor100);
    border-top-width: 1px;
    border-top-style: solid;
    font-size: 14px;
    font-weight: 700;
    margin: ${marginSizes[spacing]};
    display: flex;
    ${roundness === "default" && (0, _styledComponents.css)`
      border-bottom-left-radius: var(--borderRadius100);
      border-bottom-right-radius: var(--borderRadius100);
    `}
    ${roundness === "large" && (0, _styledComponents.css)`
      border-bottom-left-radius: var(--borderRadius200);
      border-bottom-right-radius: var(--borderRadius200);
    `}

    ${_cardColumn.default} {
      margin: 0;
      padding: ${paddingSizes[spacing]};
    }
  `}
`;
var _default = exports.default = StyledCardFooter;