"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TopModalContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopModalContext = /*#__PURE__*/(0, _react.createContext)({
  topModal: null
});
const TopModalContextProvider = ({
  children
}) => {
  const [topModal, setTopModal] = (0, _react.useState)(null);

  // can't add the setter to the global list inside useEffect because that doesn't run until
  // after the render. We use a ref to ensure it only runs once.
  const isFirstRender = (0, _react.useRef)(true);
  if (isFirstRender.current) {
    if (!window.__CARBON_INTERNALS_MODAL_SETTER_LIST) {
      window.__CARBON_INTERNALS_MODAL_SETTER_LIST = [];
    }
    window.__CARBON_INTERNALS_MODAL_SETTER_LIST.push(setTopModal);
    isFirstRender.current = false;
  }
  (0, _react.useEffect)(() => {
    return () => {
      window.__CARBON_INTERNALS_MODAL_SETTER_LIST = window.__CARBON_INTERNALS_MODAL_SETTER_LIST?.filter(setter => setter !== setTopModal);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(TopModalContext.Provider, {
    value: {
      topModal
    }
  }, children);
};
exports.TopModalContextProvider = TopModalContextProvider;
var _default = exports.default = TopModalContext;