import React from "react";
import type { ThemeObject } from "../../style/themes";
export interface CarbonProviderProps {
    children: React.ReactNode;
    /** Theme which specifies styles to apply to all child components. Set to `sageTheme` by default. */
    theme?: Partial<ThemeObject>;
    /** Feature flag for opting in to the latest validation designs for components that support it.
     *
     * NOTE - Will eventually be set to `true` by default in the future. */
    validationRedesignOptIn?: boolean;
    /** Feature flag for opting out of styling components to have rounded corners.
     *
     * NOTE - Will eventually be set to `false` by default in the future. */
    roundedCornersOptOut?: boolean;
    focusRedesignOptOut?: boolean;
}
export declare const NewValidationContext: React.Context<Pick<CarbonProviderProps, "validationRedesignOptIn" | "roundedCornersOptOut" | "focusRedesignOptOut">>;
export declare const CarbonProvider: ({ children, theme, validationRedesignOptIn, roundedCornersOptOut, focusRedesignOptOut, }: CarbonProviderProps) => React.JSX.Element;
export default CarbonProvider;
