"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledButtonSubtext = exports.StyledButtonMainText = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _buttonTypes = _interopRequireDefault(require("./button-types.style"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function additionalIconStyle(iconType) {
  if (iconType === "services") return "6px";
  return "20px";
}
function stylingForIconOnly(size) {
  let dimension = "";
  switch (size) {
    case "small":
      dimension = "32px";
      break;
    case "large":
      dimension = "48px";
      break;
    default:
      dimension = "40px";
  }
  return `
  padding: 0px; 
  width: ${dimension}; 
  min-height: ${dimension}`;
}
function stylingForType({
  iconOnly,
  disabled,
  buttonType,
  size,
  destructive
}) {
  return (0, _styledComponents.css)`
    ${(0, _buttonTypes.default)(disabled, destructive)[buttonType]};

    ${size === "small" && (0, _styledComponents.css)`
      font-size: var(--fontSizes100);
      min-height: 32px;
    `}

    ${size === "medium" && (0, _styledComponents.css)`
      font-size: var(--fontSizes100);
      min-height: 40px;
    `}
    
    ${size === "large" && (0, _styledComponents.css)`
      font-size: var(--fontSizes200);
      min-height: 48px;
    `}

    ${iconOnly && stylingForIconOnly(size)}
  `;
}
const oldFocusStyling = "outline: solid 3px var(--colorsSemanticFocus500);";
const StyledButton = _styledComponents.default.button`
  ${_styledSystem.space}
  ${({
  disabled,
  noWrap,
  theme
}) => (0, _styledComponents.css)`
    align-items: center;
    cursor: ${disabled ? "not-allowed" : "pointer"};
    display: inline-flex;
    ${noWrap ? "white-space: nowrap;" : "flex-flow: wrap;"}
    justify-content: center;
    vertical-align: middle;
    outline-offset: 0;
    border: 2px solid transparent;
    box-sizing: border-box;
    font-weight: 600;
    text-decoration: none;
    border-radius: var(--borderRadius400);

    &:focus {
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
    }

    ${stylingForType}
  `}

  ${({
  fullWidth
}) => fullWidth && (0, _styledComponents.css)`
      width: 100%;
    `}
    
  ${({
  iconOnly,
  iconPosition,
  iconType
}) => (0, _styledComponents.css)`
    ${_icon.default} {
      margin-left: ${!iconOnly && iconPosition === "after" ? "var(--spacing100)" : "0px"};
      margin-right: ${!iconOnly && iconPosition === "before" ? "var(--spacing100)" : "0px"};
      margin-bottom: ${iconOnly ? "1px" : "0px"};
      height: ${additionalIconStyle(iconType)};
      width: 20px;
      svg {
        margin-top: 0;
      }
      ${iconOnly && "margin-left: auto; margin-right: auto"}
    }
  `}
`;
const StyledButtonSubtext = exports.StyledButtonSubtext = _styledComponents.default.span`
  font-size: 14px;
  font-weight: 400;
  display: block;
`;
const StyledButtonMainText = exports.StyledButtonMainText = _styledComponents.default.span`
  display: flex;
  align-items: center;
`;
StyledButton.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledButton;