import React from "react";
import { SpaceProps } from "styled-system";
import { IconType } from "../icon";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
import { TooltipPositions } from "../tooltip/tooltip.config";
export declare type ButtonTypes = "primary" | "secondary" | "tertiary" | "darkBackground" | "gradient-grey" | "gradient-white";
export declare type SizeOptions = "small" | "medium" | "large";
export declare type ButtonIconPosition = "before" | "after";
export interface ButtonProps extends SpaceProps, TagProps {
    /**
     * Prop to specify the aria-label attribute of the component
     * Defaults to the iconType, when the component has only an icon
     */
    "aria-label"?: string;
    /** Identifies the element(s) labelling the button. */
    "aria-labelledby"?: string;
    /** Identifies the element(s) offering additional information about the button the user might require. */
    "aria-describedby"?: string;
    /** Color variants for new business themes: "primary" | "secondary" | "tertiary" | "darkBackground" */
    buttonType?: ButtonTypes;
    /** The text the button displays */
    children?: React.ReactNode;
    /** Name attribute */
    name?: string;
    /** Apply disabled state to the button */
    disabled?: boolean;
    /** Apply destructive style to the button */
    destructive?: boolean;
    /** Apply fullWidth style to the button */
    fullWidth?: boolean;
    /** Used to transform button into anchor */
    href?: string;
    /** Defines an Icon position related to the children: "before" | "after" */
    iconPosition?: ButtonIconPosition;
    /** Provides a tooltip message when the icon is hovered. */
    iconTooltipMessage?: string;
    /** Provides positioning when the tooltip is displayed. */
    iconTooltipPosition?: TooltipPositions;
    /** Defines an Icon type within the button */
    iconType?: IconType;
    /** id attribute */
    id?: string;
    /** If provided, the text inside a button will not wrap */
    noWrap?: boolean;
    /** Specify a callback triggered on blur */
    onBlur?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Specify a callback triggered on change */
    onChange?: (ev: React.ChangeEvent<HTMLButtonElement>) => void;
    /** Specify a callback triggered on focus */
    onFocus?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Specify a callback triggered on keyDown */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLButtonElement>) => void;
    /** onClick handler */
    onClick?: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>) => void;
    /** Assigns a size to the button: "small" | "medium" | "large" */
    size?: SizeOptions;
    /** Second text child, renders under main text, only when size is "large" */
    subtext?: string;
    /** HTML button type property */
    type?: string;
    /** HTML target attribute */
    target?: string;
    /** HTML rel attribute */
    rel?: string;
    /**
     * @private
     * @internal
     * Set a class name on the button element
     */
    className?: string;
}
declare const Button: React.ForwardRefExoticComponent<ButtonProps & React.RefAttributes<HTMLButtonElement>>;
export default Button;
