"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paddingConfig = exports.heightConfig = exports.fontSizeConfig = exports.StyledButtonToggleWrapper = exports.StyledButtonToggleIcon = exports.StyledButtonToggleContentWrapper = exports.StyledButtonToggle = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const heightConfig = exports.heightConfig = {
  small: 24,
  medium: 32,
  large: 40
};
const fontSizeConfig = exports.fontSizeConfig = {
  small: 14,
  medium: 14,
  large: 16
};
const paddingConfig = exports.paddingConfig = {
  small: 8,
  medium: 8,
  large: 12
};
const heightLargeIconConfig = {
  small: 72,
  medium: 88,
  large: 120
};
const paddingLargeIconConfig = {
  small: 24,
  medium: 40,
  large: 48
};
const StyledButtonToggleContentWrapper = exports.StyledButtonToggleContentWrapper = _styledComponents.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 100%;
  height: 100%;
  flex-flow: wrap;
`;
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledButtonToggle = exports.StyledButtonToggle = _styledComponents.default.button`
  display: inline-flex;
  justify-content: center;
  align-items: center;
  position: relative;
  box-sizing: border-box;
  max-width: 100%;

  font-weight: 700;
  background-color: transparent;
  cursor: pointer;
  text-align: start;
  color: var(--colorsActionMinor500);
  border: none;

  ${_icon.default} {
    color: var(--colorsActionMinor500);
  }

  ${({
  size
}) => (0, _styledComponents.css)`
    height: ${heightConfig[size]}px;
    padding: 0 ${paddingConfig[size]}px;
    font-size: ${fontSizeConfig[size]}px;
  `}

  ${({
  buttonIcon,
  buttonIconSize,
  size
}) => buttonIcon && buttonIconSize === "large" && (0, _styledComponents.css)`
      height: ${heightLargeIconConfig[size]}px;
      padding: 0 ${paddingLargeIconConfig[size]}px;
      flex-direction: column;
    `}  
    
  &:focus {
    ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
    z-index: 100;
  }

  &:not(:disabled):hover {
    background-color: var(--colorsActionMinor600);
    color: var(--colorsActionMinorYang100);
    ${_icon.default} {
      color: var(--colorsActionMinorYang100);
    }
  }

  &[aria-pressed="true"] {
    background-color: var(--colorsActionMinor850);
    color: var(--colorsActionMinorYang100);

    ${_icon.default} {
      color: var(--colorsActionMinorYang100);
    }

    ${({
  allowDeselect
}) => !allowDeselect && (0, _styledComponents.css)`
        cursor: auto;
      `}
  }

  ${({
  disabled
}) => disabled && (0, _styledComponents.css)`
      cursor: not-allowed;

      & {
        color: var(--colorsActionMinorYin030);
        ${_icon.default} {
          color: var(--colorsActionMinorYin030);
        }
      }

      &[aria-pressed="true"] {
        cursor: not-allowed;
        background-color: var(--colorsActionMinorYin030);
      }
    `}
`;
const iconFontSizes = {
  smallIcon: 20,
  largeIcon: 32
};
const StyledButtonToggleIcon = exports.StyledButtonToggleIcon = _styledComponents.default.div`
  ${({
  hasContent
}) => hasContent && `margin-right: 8px;`}
  ${({
  buttonIconSize
}) => buttonIconSize === "large" && (0, _styledComponents.css)`
      margin-right: 0;
      ${_icon.default} {
        margin-left: 0;
        margin-right: 0;
        margin-bottom: 8px;
        height: ${`${iconFontSizes.largeIcon}px`};
        width: ${`${iconFontSizes.largeIcon}px`};
      }
      ${_icon.default}::before {
        font-size: ${`${iconFontSizes[`${buttonIconSize}Icon`]}px`};
        line-height: ${`${iconFontSizes[`${buttonIconSize}Icon`]}px`};
      }
      .carbon-icon__svg--credit-card-slash {
        margin-left: 6px;
      }
    `}
`;
StyledButtonToggle.defaultProps = {
  theme: _base.default
};
const StyledButtonToggleWrapper = exports.StyledButtonToggleWrapper = _styledComponents.default.div`
  display: inline-block;
  vertical-align: middle;

  ${({
  grouped
}) => (0, _styledComponents.css)`
      ${!grouped && (0, _styledComponents.css)`
        &&&& {
          ${StyledButtonToggle} {
            border-radius: var(--borderRadius050);
          }
        }
      `}

      ${grouped && (0, _styledComponents.css)`
        &&&& {
          :first-of-type {
            ${StyledButtonToggle} {
              border-top-left-radius: var(--borderRadius050);
              border-bottom-left-radius: var(--borderRadius050);
            }
          }

          :last-of-type {
            ${StyledButtonToggle} {
              border-top-right-radius: var(--borderRadius050);
              border-bottom-right-radius: var(--borderRadius050);
            }
          }
        }
      `}
    `}

  ${({
  grouped
}) => grouped && (0, _styledComponents.css)`
      &:not(:first-of-type) {
        margin-left: -1px;
      }
    `};
`;