import { IconType } from "../icon";
export declare type ButtonToggleIconSizes = "small" | "large";
export declare const heightConfig: {
    small: number;
    medium: number;
    large: number;
};
export declare const fontSizeConfig: {
    small: number;
    medium: number;
    large: number;
};
export declare const paddingConfig: {
    small: number;
    medium: number;
    large: number;
};
declare const StyledButtonToggleContentWrapper: import("styled-components").StyledComponent<"div", any, {}, never>;
export interface StyledButtonToggleProps {
    /** The icon to be rendered inside of the button */
    buttonIcon?: IconType;
    /** Sets the size of the buttonIcon (eg. large) */
    buttonIconSize?: ButtonToggleIconSizes;
    /** Disable all user interaction. */
    disabled?: boolean;
    /** ButtonToggle size */
    size: "small" | "medium" | "large";
    grouped?: boolean;
    /** Allow button to be deselected when already selected */
    allowDeselect?: boolean;
}
declare const StyledButtonToggle: import("styled-components").StyledComponent<"button", any, StyledButtonToggleProps, never>;
export interface StyledButtonToggleIconProps {
    /** Sets the size of the buttonIcon (eg. large) */
    buttonIconSize?: ButtonToggleIconSizes;
    hasContent?: boolean;
}
declare const StyledButtonToggleIcon: import("styled-components").StyledComponent<"div", any, StyledButtonToggleIconProps, never>;
export interface StyledButtonToggleWrapperProps {
    grouped?: boolean;
}
declare const StyledButtonToggleWrapper: import("styled-components").StyledComponent<"div", any, StyledButtonToggleWrapperProps, never>;
export { StyledButtonToggle, StyledButtonToggleWrapper, StyledButtonToggleIcon, StyledButtonToggleContentWrapper, };
