"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ButtonToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _buttonToggle = require("./button-toggle.style");
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _buttonToggleGroup = require("./button-toggle-group/button-toggle-group.component");
var _buttonToggleIcon = _interopRequireDefault(require("./button-toggle-icon.component"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
var _inputBehaviour = require("../../__internal__/input-behaviour");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateCheckedWarnTriggered = false;
let deprecateNameWarnTriggered = false;
let deprecateUncontrolledWarnTriggered = false;
let deprecateGroupedWarnTriggered = false;
const ButtonToggle = ({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  buttonIcon,
  buttonIconSize = "small",
  checked,
  children,
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  disabled,
  grouped,
  name,
  onBlur,
  onFocus,
  onClick,
  pressed,
  size = "medium",
  value
}) => {
  !!!(children || buttonIcon) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "Either prop `buttonIcon` must be defined, or this node must have children") : (0, _invariant.default)(false) : void 0;
  if (checked !== undefined && !deprecateCheckedWarnTriggered) {
    deprecateCheckedWarnTriggered = true;
    _logger.default.deprecate("The `checked` prop in `ButtonToggle` component is deprecated and will soon be removed. Please use `pressed` instead.");
  }
  if (name && !deprecateNameWarnTriggered) {
    deprecateNameWarnTriggered = true;
    _logger.default.deprecate(`The \`name\` prop in \`ButtonToggle\` component is deprecated and will soon be removed. It does not provide any functionality
      since the component can no longer be used in an uncontrolled fashion.`);
  }
  if (grouped && !deprecateGroupedWarnTriggered) {
    deprecateGroupedWarnTriggered = true;
    _logger.default.deprecate("The `grouped` prop in `ButtonToggle` component is deprecated and will soon be removed. Spacing between buttons is no longer no removed.");
  }
  const pressedPropValue = pressed === undefined ? checked : pressed;
  const buttonRef = (0, _react.useRef)(null);
  const {
    onMouseEnter,
    onMouseLeave,
    onBlur: inputGroupOnBlur,
    onFocus: inputGroupOnFocus
  } = (0, _react.useContext)(_inputBehaviour.InputGroupContext);
  const {
    onButtonClick,
    handleKeyDown,
    pressedButtonValue,
    onChange,
    name: groupName,
    allowDeselect,
    isInGroup,
    isDisabled,
    firstButton,
    childButtonCallbackRef,
    hintTextId
  } = (0, _react.useContext)(_buttonToggleGroup.ButtonToggleGroupContext);
  const callbackRef = element => {
    buttonRef.current = element;
    if (childButtonCallbackRef) {
      childButtonCallbackRef(element);
    }
  };
  const inputGuid = (0, _react.useRef)((0, _guid.default)());
  function handleClick(ev) {
    if (onClick) {
      onClick(ev);
    }
    if (onChange) {
      let newValue = value;
      if (allowDeselect && pressedButtonValue === value) {
        newValue = undefined;
      }
      onChange(ev, newValue, groupName || name);
    }
    if (value) {
      onButtonClick(value);
    }
  }
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Button Toggle` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  function handleFocus(ev) {
    if (onFocus) {
      onFocus(ev);
    }
    if (inputGroupOnFocus) {
      inputGroupOnFocus();
    }
  }
  function handleBlur(ev) {
    if (onBlur) {
      onBlur(ev);
    }
    if (inputGroupOnBlur) {
      inputGroupOnBlur();
    }
  }
  const isPressed = isInGroup ? pressedButtonValue === value : pressedPropValue;
  const isFirstButton = buttonRef.current === firstButton;

  // if we're in a ButtonToggleGroup, only one button should be tabbable - the pressed button if there is one, or
  // the first one if not
  const tabbable = !isInGroup || isPressed || !pressedButtonValue && isFirstButton;
  return /*#__PURE__*/_react.default.createElement(_buttonToggle.StyledButtonToggleWrapper, {
    "data-component": dataComponent || "button-toggle",
    "data-element": dataElement,
    "data-role": dataRole,
    grouped: grouped
  }, /*#__PURE__*/_react.default.createElement(_buttonToggle.StyledButtonToggle, _extends({
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    "aria-describedby": hintTextId || undefined,
    "aria-pressed": !!isPressed,
    buttonIcon: buttonIcon,
    buttonIconSize: buttonIconSize,
    "data-element": "button-toggle-button",
    disabled: disabled || isDisabled,
    id: inputGuid.current,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    size: size,
    grouped: grouped,
    value: value,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onClick: handleClick,
    onKeyDown: handleKeyDown
    // In Safari non-text input elements do not gain focus on click. To get around this, we have to apply a tab-index of 0 here.
    // This is to allow the ButtonToggle component to be focused when it is the first tabbable element.
  }, tabbable ? {
    tabIndex: 0
  } : {
    tabIndex: -1
  }, {
    allowDeselect: allowDeselect,
    ref: callbackRef
  }), buttonIcon && /*#__PURE__*/_react.default.createElement(_buttonToggleIcon.default, {
    buttonIcon: buttonIcon,
    buttonIconSize: buttonIconSize,
    disabled: disabled,
    hasContent: !!children
  }), children));
};
exports.ButtonToggle = ButtonToggle;
ButtonToggle.displayName = "ButtonToggle";
var _default = exports.default = ButtonToggle;