"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledHintText = exports.StyledButtonToggleGroupWrapper = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../../style/themes");
var _buttonToggle = require("../button-toggle.style");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledButtonToggleGroup = _styledComponents.default.div`
  ${_styledSystem.margin}

  display: flex;
  box-shadow: inset 0px 0px 0px 1px var(--colorsActionMinor500);
  border-radius: var(--borderRadius100);
  padding: 4px;
  gap: 4px;
  width: fit-content;
  height: fit-content;
  flex-wrap: wrap;

  ${({
  disabled
}) => disabled && (0, _styledComponents.css)`
      cursor: not-allowed;
      box-shadow: inset 0px 0px 0px 1px var(--colorsActionDisabled600);
    `}

  ${({
  fullWidth
}) => fullWidth && (0, _styledComponents.css)`
      width: 100%;
      ${_buttonToggle.StyledButtonToggle} {
        width: 100%;
      }
      ${_buttonToggle.StyledButtonToggleWrapper} {
        flex: auto;
      }
    `}

  ${({
  inputWidth
}) => inputWidth && (0, _styledComponents.css)`
      width: ${`${inputWidth}%`};
    `}
`;
const StyledButtonToggleGroupWrapper = exports.StyledButtonToggleGroupWrapper = _styledComponents.default.div`
  ${({
  labelInline
}) => labelInline && (0, _styledComponents.css)`
      display: flex;
      ${StyledButtonToggleGroup} {
        flex-wrap: nowrap;
      }
    `}
`;
const StyledHintText = exports.StyledHintText = _styledComponents.default.div`
  ::after {
    content: " ";
  }

  margin-top: var(--spacing000);
  margin-bottom: var(--spacing150);
  color: ${({
  isDisabled
}) => isDisabled ? "var(--colorsUtilityYin030)" : "var(--colorsUtilityYin055)"};
  font-size: 14px;
`;
StyledButtonToggleGroup.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledButtonToggleGroup;