"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ButtonToggleGroupContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _formField = _interopRequireDefault(require("../../../__internal__/form-field"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _buttonToggleGroup = _interopRequireWildcard(require("./button-toggle-group.style"));
var _ = require("..");
var _utils = require("../../../style/utils");
var _tooltipProvider = require("../../../__internal__/tooltip-provider");
var _inputBehaviour = require("../../../__internal__/input-behaviour");
var _logger = _interopRequireDefault(require("../../../__internal__/utils/logger"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _carbonProvider = require("../../carbon-provider/carbon-provider.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateNameWarnTriggered = false;
const BUTTON_TOGGLE_SELECTOR = '[data-element="button-toggle-button"]';
const ButtonToggleGroupContext = exports.ButtonToggleGroupContext = /*#__PURE__*/(0, _react.createContext)({
  onButtonClick: /* istanbul ignore next */() => {},
  handleKeyDown: /* istanbul ignore next */() => {},
  pressedButtonValue: undefined,
  allowDeselect: false,
  isInGroup: false,
  isDisabled: false
});
const ButtonToggleGroup = ({
  children,
  fieldHelp,
  fieldHelpInline,
  "aria-label": ariaLabel,
  label,
  labelHelp,
  labelSpacing,
  inputHint,
  inputWidth,
  fullWidth,
  labelInline,
  labelWidth,
  name,
  onChange,
  value,
  "data-component": dataComponent = "button-toggle-group",
  "data-element": dataElement,
  "data-role": dataRole,
  helpAriaLabel,
  id,
  allowDeselect,
  disabled,
  className,
  ...props
}) => {
  const hasCorrectItemStructure = (0, _react.useMemo)(() => {
    const incorrectChild = _react.default.Children.toArray(children).find(child => {
      return ! /*#__PURE__*/_react.default.isValidElement(child) || child.type.displayName !== _.ButtonToggle.displayName;
    });
    return !incorrectChild;
  }, [children]);
  !hasCorrectItemStructure ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `\`ButtonToggleGroup\` only accepts children of type \`${_.ButtonToggle.displayName}\``) : (0, _invariant.default)(false) : void 0;
  const labelId = (0, _react.useRef)((0, _guid.default)());
  const hintTextId = (0, _react.useRef)((0, _guid.default)());
  const wrapperRef = (0, _react.useRef)(null);
  const [pressedButtonValue, setPressedButtonValue] = (0, _react.useState)();
  if (name && !deprecateNameWarnTriggered) {
    deprecateNameWarnTriggered = true;
    _logger.default.deprecate(`The \`name\` prop in \`ButtonToggleGroup\` component is deprecated and will soon be removed. It does not provide any functionality
      since the component can no longer be used in an uncontrolled fashion.`);
  }
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const computeLabelPropValues = prop => validationRedesignOptIn ? undefined : prop;
  const onButtonClick = buttonValue => {
    let newValue = buttonValue;
    const currentValue = value || pressedButtonValue;
    if (allowDeselect && currentValue === buttonValue) {
      newValue = undefined;
    }
    setPressedButtonValue(newValue);
  };
  const getInnerButtons = () => wrapperRef.current?.querySelectorAll(BUTTON_TOGGLE_SELECTOR);
  // needs to be state not ref, so that a rerender is triggered
  const [firstButton, setFirstButton] = (0, _react.useState)();
  const handleKeyDown = ev => {
    const innerButtons = getInnerButtons();
    // istanbul ignore if
    if (!innerButtons || !document.activeElement) {
      return;
    }
    const focusedIndex = Array.from(innerButtons).indexOf(document.activeElement);
    let nextElement;
    if (_events.default.isLeftKey(ev)) {
      const nextIndex = focusedIndex === 0 ? innerButtons.length - 1 : focusedIndex - 1;
      nextElement = innerButtons[nextIndex];
    } else if (_events.default.isRightKey(ev)) {
      const nextIndex = (focusedIndex + 1) % innerButtons.length;
      nextElement = innerButtons[nextIndex];
    }
    // istanbul ignore else
    if (nextElement instanceof HTMLButtonElement) {
      nextElement.focus();
    }
  };
  const childButtonCallbackRef = button => {
    // setTimeout needed as otherwise innerButtons aren't picked up by the query even though the ref is attached
    setTimeout(() => {
      // guard needed to avoid warnings about setting state on an unmounted component - the callback ref will
      // get called with null when the component is about to be unmounted, and it has been unmounted by the time
      // the setTimeout completes
      /* istanbul ignore else */
      if (button) {
        const innerButtons = getInnerButtons();
        /* istanbul ignore if */
        if (!innerButtons) {
          setFirstButton(undefined);
        } else if (button === innerButtons[0]) {
          setFirstButton(button);
        }
      }
    }, 0);
  };
  return /*#__PURE__*/_react.default.createElement(_tooltipProvider.TooltipProvider, {
    helpAriaLabel: helpAriaLabel
  }, /*#__PURE__*/_react.default.createElement(_inputBehaviour.InputGroupBehaviour, null, /*#__PURE__*/_react.default.createElement(_formField.default, _extends({
    label: label,
    labelHelp: computeLabelPropValues(labelHelp),
    labelSpacing: computeLabelPropValues(labelSpacing),
    fieldHelp: computeLabelPropValues(fieldHelp),
    fieldHelpInline: computeLabelPropValues(fieldHelpInline),
    labelInline: computeLabelPropValues(labelInline),
    labelWidth: computeLabelPropValues(labelWidth),
    labelId: labelId.current,
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    id: id,
    labelAs: "span",
    disabled: disabled
  }, (0, _utils.filterStyledSystemMarginProps)(props)), /*#__PURE__*/_react.default.createElement(ButtonToggleGroupContext.Provider, {
    value: {
      onButtonClick,
      handleKeyDown,
      pressedButtonValue: value || pressedButtonValue,
      onChange,
      name,
      allowDeselect,
      isInGroup: true,
      isDisabled: disabled,
      firstButton,
      childButtonCallbackRef,
      hintTextId: inputHint ? hintTextId.current : undefined
    }
  }, inputHint && /*#__PURE__*/_react.default.createElement(_buttonToggleGroup.StyledHintText, {
    id: hintTextId.current,
    isDisabled: disabled
  }, inputHint), /*#__PURE__*/_react.default.createElement(_buttonToggleGroup.StyledButtonToggleGroupWrapper, {
    labelInline: labelInline,
    ref: wrapperRef
  }, /*#__PURE__*/_react.default.createElement(_buttonToggleGroup.default, _extends({}, label ? {
    "aria-labelledby": labelId.current
  } : {
    "aria-label": ariaLabel
  }, {
    inputWidth: inputWidth,
    fullWidth: fullWidth,
    role: "group",
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    id: id,
    className: className,
    disabled: disabled
  }), children))))));
};
ButtonToggleGroup.displayName = "ButtonToggleGroup";
var _default = exports.default = ButtonToggleGroup;