import React from "react";
import { MarginProps } from "styled-system";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
export interface CustomEvent {
    target: {
        name?: string;
        value?: string;
    };
}
export interface ButtonToggleGroupProps extends MarginProps, TagProps {
    /** Unique id for the root element of the component */
    id: string;
    /** Specifies the name prop to be applied to each button in the group */
    name?: string;
    /** Toggle buttons to be rendered. Only accepts children of type ButtonToggle */
    children?: React.ReactNode;
    /** aria-label for the group wrapper. Required for accessibility when no text label is provided */
    "aria-label"?: string;
    /** Text for the visible label of the button group. */
    label?: string;
    /** [Legacy] Text for the label's help tooltip. */
    labelHelp?: React.ReactNode;
    /** [Legacy] Spacing between label and a field for inline label, given number will be multiplied by base spacing unit (8) */
    labelSpacing?: 1 | 2;
    /** A hint string rendered before the input but after the label. Intended to describe the purpose or content of the input. */
    inputHint?: React.ReactNode;
    /** The percentage width of the ButtonToggleGroup. */
    inputWidth?: number | string;
    /** [Legacy] The text for the field help. */
    fieldHelp?: string;
    /** [Legacy] Sets the field help to inline. */
    fieldHelpInline?: boolean;
    /** [Legacy] Sets the label to be inline. */
    labelInline?: boolean;
    /** [Legacy] The percentage width of the label. */
    labelWidth?: number;
    /** If true all ButtonToggle children will flex to the full width of the ButtonToggleGroup parent */
    fullWidth?: boolean;
    /** Callback triggered by pressing one of the child buttons. Use with controlled components to set the value prop to the value argument */
    onChange?: (ev: React.MouseEvent<HTMLButtonElement>, value?: string, name?: string) => void;
    /** Determines which child button is selected when the component is used as a controlled component */
    value?: string;
    /** [Legacy] Aria label for rendered help component */
    helpAriaLabel?: string;
    /** Allow buttons within the group to be deselected when already selected, leaving no selected button */
    allowDeselect?: boolean;
    /** Disable all user interaction. */
    disabled?: boolean;
    /**
     * @private @ignore
     * Set a class on the component
     */
    className?: string;
}
declare type ButtonToggleGroupContextType = {
    onButtonClick: (value: string) => void;
    handleKeyDown: (ev: React.KeyboardEvent<HTMLButtonElement>) => void;
    pressedButtonValue?: string;
    onChange?: (ev: React.MouseEvent<HTMLButtonElement>, value?: string, name?: string) => void;
    name?: string;
    allowDeselect?: boolean;
    isInGroup: boolean;
    isDisabled?: boolean;
    firstButton?: HTMLButtonElement;
    childButtonCallbackRef?: (button: HTMLButtonElement | null) => void;
    /** Identifier for the hint text, if it exists, that is rendered by ButtonToggleGroup */
    hintTextId?: string;
};
export declare const ButtonToggleGroupContext: React.Context<ButtonToggleGroupContextType>;
declare const ButtonToggleGroup: {
    ({ children, fieldHelp, fieldHelpInline, "aria-label": ariaLabel, label, labelHelp, labelSpacing, inputHint, inputWidth, fullWidth, labelInline, labelWidth, name, onChange, value, "data-component": dataComponent, "data-element": dataElement, "data-role": dataRole, helpAriaLabel, id, allowDeselect, disabled, className, ...props }: ButtonToggleGroupProps): React.JSX.Element;
    displayName: string;
};
export default ButtonToggleGroup;
