"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _button = _interopRequireDefault(require("../button"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _loaderSquare = _interopRequireDefault(require("../loader/loader-square.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function makeColors(color) {
  return `
    color: ${color};
    ${_icon.default} {
      color: ${color};
    }
    ${_loaderSquare.default} {
      background-color: ${color};
    }
  `;
}
const StyledButtonMinor = (0, _styledComponents.default)(_button.default)`
  border-radius: var(--borderRadius050);

  ${({
  children
}) => !children && (0, _styledComponents.css)`
      ${_icon.default} {
        position: absolute;
      }
    `}

  ${({
  buttonType,
  destructive,
  disabled
}) => !destructive && !disabled && (0, _styledComponents.css)`
      ${buttonType === "primary" && `
        background: var(--colorsActionMinor500);
        border-color: var(--colorsActionMinorTransparent);
        ${makeColors("var(--colorsActionMinorYang100)")}
        &:hover {
          background: var(--colorsActionMinor600);
        }
      `}

      ${buttonType === "secondary" && `
        background: transparent;
        padding: var(--spacing100);
        border-color: var(--colorsActionMinor500);
        ${makeColors("var(--colorsActionMinor500)")}
        &:hover {
          color: var(--colorsActionMinorYang100);
          background: var(--colorsActionMinor600);
        }
      `}

      ${buttonType === "tertiary" && `
        background: transparent;
        padding: var(--spacing100);
        ${makeColors("var(--colorsActionMinor500)")}
        &:hover {
          color: var(--colorsActionMinorYang100);
          background: var(--colorsActionMinor600);
        }
      `}
    `}
    
    ${({
  isInPassword,
  disabled
}) => isInPassword && !disabled && (0, _styledComponents.css)`
      ${_icon.default} {
        color: var(--colorsUtilityMajor300);
      }

      &:hover {
        ${_icon.default} {
          color: var(--colorsUtilityMajor300);
        }
        color: var(--colorsActionMinor500);
        background: transparent;
      }
    `}

  ${({
  size
}) => (0, _styledComponents.css)`
    ${size === "small" && `
      min-height: var(--sizing400);
      padding: var(--spacing000) var(--spacing100) var(--spacing000)
        var(--spacing100);
    `}

    ${size === "medium" && `
      padding-left: var(--spacing150);
      padding-right: var(--spacing150);
    `}

    ${size === "large" && `
      padding-left: var(--spacing200);
      padding-right: var(--spacing200);
    `}
  `}
`;
var _default = exports.default = StyledButtonMinor;