"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ButtonMinor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _buttonMinor = _interopRequireDefault(require("./button-minor.style"));
var _buttonBar = require("../button-bar/button-bar.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ButtonMinor = exports.ButtonMinor = /*#__PURE__*/_react.default.forwardRef(({
  buttonType: buttonTypeProp = "secondary",
  disabled = false,
  destructive = false,
  size: sizeProp = "medium",
  iconPosition: iconPositionProp = "before",
  fullWidth: fullWidthProp = false,
  ...rest
}, ref) => {
  const {
    buttonType: buttonTypeContext,
    size: sizeContext,
    iconPosition: iconPositionContext,
    fullWidth: fullWidthContext
  } = (0, _react.useContext)(_buttonBar.ButtonBarContext);
  const buttonType = buttonTypeContext || buttonTypeProp;
  const size = sizeContext || sizeProp;
  const iconPosition = iconPositionContext || iconPositionProp;
  const fullWidth = fullWidthContext || fullWidthProp;
  return /*#__PURE__*/_react.default.createElement(_buttonMinor.default, _extends({
    ref: ref,
    "data-component": "button-minor",
    size: size,
    fullWidth: fullWidth,
    iconPosition: iconPosition,
    buttonType: buttonType,
    disabled: disabled,
    destructive: destructive
  }, rest));
});


ButtonMinor.displayName = "ButtonMinor";
var _default = exports.default = ButtonMinor;