"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _button = _interopRequireDefault(require("../button/button.style"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const commonHoverStyles = `
  background-color: var(--colorsActionMajor600);
  border-color: var(--colorsActionMajor600);
`;
const StyledButtonBar = _styledComponents.default.div`
  ${_styledSystem.space}
  ${({
  fullWidth,
  size
}) => (0, _styledComponents.css)`
    ${fullWidth && (0, _styledComponents.css)`
      width: 100%;
      display: flex;
      button {
        box-sizing: content-box;
        padding: 0;
        width: 100%;
        ${size === "small" && "min-height: 28px"}
        ${size === "medium" && "min-height: 36px"}
          ${size === "large" && "min-height: 44px"}
      }
    `}

    button {
      margin: 0;

      :not(:first-child):not(:last-child) {
        border-radius: var(--borderRadius000);
      }
      :first-child:not(:last-child) {
        border-top-right-radius: var(--borderRadius000);
        border-bottom-right-radius: var(--borderRadius000);
      }
      :last-child:not(:first-child) {
        border-top-left-radius: var(--borderRadius000);
        border-bottom-left-radius: var(--borderRadius000);
      }

      &:not(:last-of-type) {
        border-right-color: transparent;
      }

      &:not(:first-of-type) {
        margin-left: -2px;
      }

      &:focus {
        position: relative;
        z-index: 2;
      }

      &:hover {
        background-color: var(--colorsActionMajor600);
        border-color: var(--colorsActionMajor600);

        & + button {
          border-left-color: var(--colorsActionMajor600);
        }

        & ${_icon.default} {
          ${commonHoverStyles}
          color: white;
        }
      }

      & ${_icon.default} {
        color: var(--colorsActionMajor500);
      }
    }

    [data-component="button"] {
      :hover {
        ${commonHoverStyles}
        & + ${_button.default} {
          border-left-color: var(--colorsActionMajor600);
        }
      }
    }

    [data-component="button-minor"] {
      & ${_icon.default} {
        color: var(--colorsActionMinor500);
      }
    }

    [data-component="button-minor"] {
      :hover {
        color: var(--colorsActionMinorYang100);
        background-color: var(--colorsActionMinor500);
        border-color: var(--colorsActionMinor500);

        & + ${_button.default} {
          border-left-color: var(--colorsActionMinor500);
        }
      }
    }

    ${_iconButton.default} {
      border: 2px solid var(--colorsActionMajor500);

      :focus {
        border-right-color: var(--colorsActionMajor500);
      }
    }
  `}
`;
StyledButtonBar.defaultProps = {
  theme: _base.default,
  size: "medium"
};
var _default = exports.default = StyledButtonBar;