"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ButtonBarContext = exports.ButtonBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _buttonBar = _interopRequireDefault(require("./button-bar.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ButtonBarContext = exports.ButtonBarContext = /*#__PURE__*/_react.default.createContext({});
const ButtonBar = ({
  children,
  size = "medium",
  iconPosition = "before",
  fullWidth = false,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_buttonBar.default, _extends({}, rest, {
  fullWidth: fullWidth,
  size: size
}), /*#__PURE__*/_react.default.createElement(ButtonBarContext.Provider, {
  value: {
    buttonType: "secondary",
    size,
    iconPosition,
    fullWidth
  }
}, children));
exports.ButtonBar = ButtonBar;
ButtonBar.displayName = "ButtonBar";
var _default = exports.default = ButtonBar;