"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
var _crumb = require("./crumb.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Crumb = /*#__PURE__*/_react.default.forwardRef(({
  href,
  isCurrent,
  children,
  onClick,
  ...rest
}, ref) => /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_crumb.StyledCrumb, _extends({
  ref: ref,
  isCurrent: isCurrent,
  "aria-current": isCurrent ? "page" : undefined
}, (0, _tags.default)("crumb", rest), rest, !isCurrent && {
  href,
  onClick
}), children), !isCurrent && /*#__PURE__*/_react.default.createElement(_crumb.Divider, null)));
if (process.env.NODE_ENV !== "production") {
  Crumb.propTypes = {
    "aria-activedescendant": _propTypes.default.string,
    "aria-atomic": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-autocomplete": _propTypes.default.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-checked": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-colcount": _propTypes.default.number,
    "aria-colindex": _propTypes.default.number,
    "aria-colspan": _propTypes.default.number,
    "aria-controls": _propTypes.default.string,
    "aria-current": _propTypes.default.oneOfType([_propTypes.default.oneOf(["date", "false", "location", "page", "step", "time", "true"]), _propTypes.default.bool]),
    "aria-describedby": _propTypes.default.string,
    "aria-details": _propTypes.default.string,
    "aria-disabled": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-dropeffect": _propTypes.default.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": _propTypes.default.string,
    "aria-expanded": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-flowto": _propTypes.default.string,
    "aria-grabbed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-haspopup": _propTypes.default.oneOfType([_propTypes.default.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), _propTypes.default.bool]),
    "aria-hidden": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-invalid": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "grammar", "spelling", "true"]), _propTypes.default.bool]),
    "aria-keyshortcuts": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "aria-level": _propTypes.default.number,
    "aria-live": _propTypes.default.oneOf(["assertive", "off", "polite"]),
    "aria-modal": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiline": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiselectable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-orientation": _propTypes.default.oneOf(["horizontal", "vertical"]),
    "aria-owns": _propTypes.default.string,
    "aria-placeholder": _propTypes.default.string,
    "aria-posinset": _propTypes.default.number,
    "aria-pressed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-readonly": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-relevant": _propTypes.default.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-roledescription": _propTypes.default.string,
    "aria-rowcount": _propTypes.default.number,
    "aria-rowindex": _propTypes.default.number,
    "aria-rowspan": _propTypes.default.number,
    "aria-selected": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-setsize": _propTypes.default.number,
    "aria-sort": _propTypes.default.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": _propTypes.default.number,
    "aria-valuemin": _propTypes.default.number,
    "aria-valuenow": _propTypes.default.number,
    "aria-valuetext": _propTypes.default.string,
    "children": _propTypes.default.node,
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "hasFocus": _propTypes.default.bool,
    "href": _propTypes.default.string,
    "isCurrent": _propTypes.default.bool,
    "onClick": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "placeholderTabIndex": _propTypes.default.bool,
    "removeAriaLabelOnIcon": _propTypes.default.bool
  };
}
Crumb.displayName = "Crumb";
var _default = exports.default = Crumb;