"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _boxGap = _interopRequireDefault(require("../../style/utils/box-gap"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _color = _interopRequireDefault(require("../../style/utils/color"));
var _box = _interopRequireDefault(require("./box.config"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const calculatePosition = props => {
  const {
    position,
    ...rest
  } = (0, _styledSystem.position)(props);
  return {
    position,
    zIndex: ["sticky", "fixed"].includes(position) ? 1 : undefined,
    ...rest
  };
};
const StyledBox = _styledComponents.default.div`
  ${_styledSystem.space}
  ${_styledSystem.layout}
  ${_styledSystem.flexbox}
  ${_styledSystem.grid}
  ${calculatePosition}

  ${({
  theme,
  borderRadius = "borderRadius000"
}) => !theme.roundedCornersOptOut && (0, _styledComponents.css)`
      border-radius: var(--${borderRadius});
    `}

  ${({
  color,
  bg,
  backgroundColor,
  ...rest
}) => (0, _color.default)({
  color,
  bg,
  backgroundColor,
  ...rest
})}

  ${({
  overflowWrap
}) => overflowWrap && (0, _styledComponents.css)`
      overflow-wrap: ${overflowWrap};
    `}
  
  ${({
  height
}) => height && (0, _styledComponents.css)`
      height: ${height};
    `}

  ${({
  width
}) => width && (0, _styledComponents.css)`
      width: ${width};
    `}

  ${({
  scrollVariant
}) => scrollVariant && (0, _styledComponents.css)`
      scrollbar-color: ${_box.default[scrollVariant].thumb}
        ${_box.default[scrollVariant].track};

      &::-webkit-scrollbar {
        width: 8px;
      }
      &::-webkit-scrollbar-track {
        background-color: ${_box.default[scrollVariant].track};
      }
      &::-webkit-scrollbar-thumb {
        background-color: ${_box.default[scrollVariant].thumb};
      }
    `}

  ${({
  boxSizing
}) => boxSizing && (0, _styledComponents.css)`
      box-sizing: ${boxSizing};
    `}

    ${({
  display,
  gap,
  columnGap,
  rowGap
}) => (display === "flex" || display === "inline-flex" || display === "grid" || display === "inline-grid") && (0, _styledComponents.css)`
      ${gap !== undefined && (0, _styledComponents.css)`
        gap: ${(0, _boxGap.default)(gap)};
      `}

      ${columnGap !== undefined && (0, _styledComponents.css)`
        column-gap: ${(0, _boxGap.default)(columnGap)};
      `}

      ${rowGap !== undefined && (0, _styledComponents.css)`
        row-gap: ${(0, _boxGap.default)(rowGap)};
      `}
    `};

  ${({
  boxShadow
}) => boxShadow && (0, _styledComponents.css)`
      box-shadow: var(--${boxShadow});
    `}
`;
StyledBox.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledBox;