"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Box = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../../style/utils");
var _box = _interopRequireDefault(require("./box.style"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Box = exports.Box = /*#__PURE__*/_react.default.forwardRef(({
  "data-component": dataComponent,
  as,
  id,
  role,
  overflowWrap,
  scrollVariant,
  boxSizing,
  tabIndex,
  gap,
  columnGap,
  rowGap,
  className,
  children,
  bg,
  backgroundColor,
  boxShadow,
  borderRadius,
  color,
  opacity,
  "aria-hidden": ariaHidden,
  ...rest
}, ref) => {
  return /*#__PURE__*/_react.default.createElement(_box.default, _extends({
    as: as,
    id: id,
    role: role,
    overflowWrap: overflowWrap,
    scrollVariant: scrollVariant,
    boxSizing: boxSizing,
    gap: gap,
    columnGap: columnGap,
    rowGap: rowGap,
    tabIndex: tabIndex,
    className: className,
    ref: ref,
    bg: bg,
    backgroundColor: backgroundColor,
    boxShadow: boxShadow,
    borderRadius: borderRadius,
    color: color,
    opacity: opacity,
    "aria-hidden": ariaHidden
  }, (0, _tags.default)(dataComponent, rest), (0, _utils.filterStyledSystemMarginProps)(rest), (0, _utils.filterStyledSystemPaddingProps)(rest), (0, _utils.filterStyledSystemFlexboxProps)(rest), (0, _utils.filterStyledSystemGridProps)(rest), (0, _utils.filterStyledSystemLayoutProps)(rest)), children);
});
if (process.env.NODE_ENV !== "production") {
  Box.propTypes = {
    "alignContent": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "space-around", "space-between", "space-evenly", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "space-around", "space-between", "space-evenly", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "alignItems": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "alignSelf": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "aria-hidden": _propTypes.default.oneOf(["false", "true"]),
    "as": _propTypes.default.oneOfType([_propTypes.default.oneOf(["a", "abbr", "address", "animate", "animateMotion", "animateTransform", "area", "article", "aside", "audio", "b", "base", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "circle", "cite", "clipPath", "code", "col", "colgroup", "data", "datalist", "dd", "defs", "del", "desc", "details", "dfn", "dialog", "div", "dl", "dt", "ellipse", "em", "embed", "feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence", "fieldset", "figcaption", "figure", "filter", "footer", "foreignObject", "form", "g", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "image", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "line", "linearGradient", "link", "main", "map", "mark", "marker", "mask", "menu", "menuitem", "meta", "metadata", "meter", "mpath", "nav", "noindex", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "path", "pattern", "picture", "polygon", "polyline", "pre", "progress", "q", "radialGradient", "rect", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "slot", "small", "source", "span", "stop", "strong", "style", "sub", "summary", "sup", "svg", "switch", "symbol", "table", "tbody", "td", "template", "text", "textarea", "textPath", "tfoot", "th", "thead", "time", "title", "tr", "track", "tspan", "u", "ul", "use", "var", "video", "view", "wbr", "webview"]), _propTypes.default.func, _propTypes.default.shape({
      "childContextTypes": _propTypes.default.object,
      "contextType": _propTypes.default.shape({
        "Consumer": _propTypes.default.func.isRequired,
        "displayName": _propTypes.default.string,
        "Provider": _propTypes.default.func.isRequired
      }),
      "contextTypes": _propTypes.default.object,
      "defaultProps": _propTypes.default.object,
      "displayName": _propTypes.default.string,
      "getDerivedStateFromError": _propTypes.default.func,
      "getDerivedStateFromProps": _propTypes.default.func,
      "propTypes": _propTypes.default.object
    })]),
    "backgroundColor": _propTypes.default.string,
    "bg": _propTypes.default.string,
    "borderRadius": _propTypes.default.any,
    "bottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "boxShadow": _propTypes.default.any,
    "boxSizing": _propTypes.default.oneOf(["border-box", "content-box"]),
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "color": _propTypes.default.string,
    "columnGap": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "display": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "-ms-flexbox", "-ms-grid", "-ms-inline-flexbox", "-ms-inline-grid", "-webkit-flex", "-webkit-inline-flex", "block", "contents", "flex", "flow-root", "flow", "grid", "inherit", "initial", "inline-block", "inline-flex", "inline-grid", "inline-list-item", "inline-table", "inline", "list-item", "none", "revert-layer", "revert", "ruby-base-container", "ruby-base", "ruby-text-container", "ruby-text", "ruby", "run-in", "table-caption", "table-cell", "table-column-group", "table-column", "table-footer-group", "table-header-group", "table-row-group", "table-row", "table", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "-ms-flexbox", "-ms-grid", "-ms-inline-flexbox", "-ms-inline-grid", "-webkit-flex", "-webkit-inline-flex", "block", "contents", "flex", "flow-root", "flow", "grid", "inherit", "initial", "inline-block", "inline-flex", "inline-grid", "inline-list-item", "inline-table", "inline", "list-item", "none", "revert-layer", "revert", "ruby-base-container", "ruby-base", "ruby-text-container", "ruby-text", "ruby", "run-in", "table-caption", "table-cell", "table-column-group", "table-column", "table-footer-group", "table-header-group", "table-row-group", "table-row", "table", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "flex": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "flexBasis": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "flexDirection": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "column-reverse", "column", "inherit", "initial", "revert-layer", "revert", "row-reverse", "row", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-initial", "column-reverse", "column", "inherit", "initial", "revert-layer", "revert", "row-reverse", "row", "unset", null])), _propTypes.default.object]),
    "flexGrow": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "flexShrink": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "flexWrap": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "nowrap", "revert-layer", "revert", "unset", "wrap-reverse", "wrap"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "nowrap", "revert-layer", "revert", "unset", "wrap-reverse", "wrap", null])), _propTypes.default.object]),
    "gap": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "gridArea": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "gridAutoColumns": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "gridAutoFlow": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "column", "dense", "inherit", "initial", "revert-layer", "revert", "row", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "column", "dense", "inherit", "initial", "revert-layer", "revert", "row", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "gridAutoRows": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "gridColumn": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "gridRow": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "gridTemplateAreas": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "none", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "none", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "gridTemplateColumns": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "gridTemplateRows": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "height": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "id": _propTypes.default.string,
    "justifyContent": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "space-around", "space-between", "space-evenly", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "space-around", "space-between", "space-evenly", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "justifyItems": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "legacy", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "legacy", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "justifySelf": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "left": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "maxHeight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "maxWidth": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "minHeight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "minWidth": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "opacity": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "order": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "overflow": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible"]), _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible", null]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })])), _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "overflowWrap": _propTypes.default.oneOf(["anywhere", "break-word"]),
    "overflowX": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible", null])), _propTypes.default.object]),
    "overflowY": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible", null])), _propTypes.default.object]),
    "p": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "padding": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pl": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "position": _propTypes.default.oneOfType([_propTypes.default.oneOf(["-moz-initial", "-webkit-sticky", "absolute", "fixed", "inherit", "initial", "relative", "revert-layer", "revert", "static", "sticky", "unset"]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["-moz-initial", "-webkit-sticky", "absolute", "fixed", "inherit", "initial", "relative", "revert-layer", "revert", "static", "sticky", "unset", null])), _propTypes.default.object]),
    "pr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "px": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "py": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "right": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "role": _propTypes.default.string,
    "rowGap": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "scrollVariant": _propTypes.default.oneOf(["dark", "light"]),
    "size": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "tabIndex": _propTypes.default.number,
    "top": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "verticalAlign": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "width": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])
  };
}
Box.displayName = "Box";
var _default = exports.default = Box;