"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSelectionCount = exports.StyledBatchSelection = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledBatchSelection = exports.StyledBatchSelection = _styledComponents.default.div`
  ${({
  disabled,
  colorTheme,
  hidden
}) => (0, _styledComponents.css)`
    align-items: center;
    display: inline-flex;
    border-radius: var(--borderRadius100);

    ${hidden && "opacity: 0;"}

    ${_icon.default} {
      color: var(--colorsActionMajorYin065);
      &:focus {
        ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
      }
    }

    ${colorTheme === "dark" && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityMajor500);
      color: var(--colorsUtilityYang100);

      ${_icon.default} {
        color: var(--colorsActionMajorYang100);
      }
    `}

    ${colorTheme === "light" && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityMajor150);
    `}

    ${colorTheme === "white" && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityYang100);
      box-shadow: var(--boxShadow100);
    `}

    ${_iconButton.default} {
      margin: 0;
      position: static;
      padding: 10px;
    }

    ${_iconButton.default}:hover {
      background-color: var(--colorsActionMajor500);
      border-radius: var(--borderRadius100);

      ${_icon.default} {
        color: var(--colorsActionMajorYang100);
      }
    }

    ${_iconButton.default}:focus {
      border-radius: var(--borderRadius100);
      z-index: 1;
      ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
    }

    ${disabled && (0, _styledComponents.css)`
      background: transparent;
      color: var(--colorsUtilityYin030);
      cursor: not-allowed;

      ${_iconButton.default} {
        background: transparent;
        pointer-events: none;

        ${_icon.default} {
          color: var(--colorsActionMajorYin030);
        }
      }
    `}
  `}
`;
const StyledSelectionCount = exports.StyledSelectionCount = _styledComponents.default.span`
  display: inline-block;
  padding: 10px 15px;
`;