"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BatchSelection = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _batchSelection = require("./batch-selection.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const BatchSelection = ({
  disabled,
  children,
  colorTheme = "transparent",
  selectedCount,
  hidden
}) => {
  const l = (0, _useLocale.default)();
  return /*#__PURE__*/_react.default.createElement(_batchSelection.StyledBatchSelection, {
    colorTheme: colorTheme,
    "data-component": "batch-selection",
    disabled: disabled,
    hidden: hidden
  }, /*#__PURE__*/_react.default.createElement(_batchSelection.StyledSelectionCount, {
    "data-element": "selection-count"
  }, l.batchSelection.selected(selectedCount)), children);
};
exports.BatchSelection = BatchSelection;
var _default = exports.default = BatchSelection;