"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledCrossIcon = exports.StyledCounter = exports.StyledBadgeWrapper = exports.StyledBadge = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _button = _interopRequireDefault(require("../button"));
var _icon2 = _interopRequireDefault(require("../icon"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _color = require("../../style/utils/color");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const commonStyles = `
  overflow: hidden;
  border-radius: var(--borderRadiusCircle);
  position: absolute;
  top: -14px;
  right: -4px;
  padding: 0;
  margin-right: 0;
  background: var(--colorsActionMajorYang100);
`;
const StyledBadgeWrapper = exports.StyledBadgeWrapper = _styledComponents.default.div`
  position: relative;
  display: inline-block;
`;
const StyledCounter = exports.StyledCounter = _styledComponents.default.div`
  font-weight: 700;
  font-size: 12px;
  margin-top: -1px;
`;
const StyledBadge = exports.StyledBadge = _styledComponents.default.span.attrs(({
  onClick
}) => ({
  as: onClick ? _button.default : undefined
}))`
  ${commonStyles}
  cursor: default;
  align-items: center;
  display: inline-flex;
  justify-content: center;
  width: 22px;
  min-height: 22px;
  border: solid 2px transparent;

  ${({
  color,
  theme
}) => (0, _styledComponents.css)`
    border-color: ${(0, _color.toColor)(theme, color)};
    color: ${(0, _color.toColor)(theme, color)};
  `};

  ::-moz-focus-inner {
    border: none;
  }

  ${({
  onClick,
  color,
  theme
}) => (0, _styledComponents.css)`
    ${onClick && `
      ${commonStyles}
      width: 26px;
      min-height: 26px;
      text-align: center;

      ::-moz-focus-inner {
        border: none;
      }

      border-color: ${(0, _color.toColor)(theme, color)};
      color: ${(0, _color.toColor)(theme, color)};      

      &:hover,
      &:focus {
        background: ${(0, _color.toColor)(theme, color)};
        border: none;
        ${StyledCounter} {
          display: none;
        }

        ${_icon.default} {
          display: block;
          width: auto;
          height: auto;
          margin-right: 0;

          :before {
            font-size: 20px;
            color: var(--colorsActionMajorYang100);
          }
        }
      }
    `}
  `}
`;
const StyledCrossIcon = exports.StyledCrossIcon = (0, _styledComponents.default)(_icon2.default)`
  margin: 0;
  display: none;
`;
StyledBadge.defaultProps = {
  theme: _base.default
};