"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Badge = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _badge = require("./badge.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Badge = ({
  "aria-label": ariaLabel,
  children,
  counter = 0,
  color = "--colorsActionMajor500",
  onClick
}) => {
  const shouldDisplayCounter = counter > 0;
  const counterToDisplay = counter > 99 ? 99 : counter;
  const renderCorrectBadge = () => {
    const props = onClick ? {
      buttonType: "secondary",
      onClick
    } : {
      "aria-label": ariaLabel
    };
    if (shouldDisplayCounter) {
      return /*#__PURE__*/_react.default.createElement(_badge.StyledBadge, _extends({
        "data-component": "badge",
        color: color
      }, props), onClick && /*#__PURE__*/_react.default.createElement(_badge.StyledCrossIcon, {
        "data-element": "badge-cross-icon",
        type: "cross"
      }), /*#__PURE__*/_react.default.createElement(_badge.StyledCounter, {
        "data-element": "badge-counter"
      }, counterToDisplay));
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_badge.StyledBadgeWrapper, null, renderCorrectBadge(), children);
};
exports.Badge = Badge;
var _default = exports.default = Badge;