"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactIs = require("react-is");
var _invariant = _interopRequireDefault(require("invariant"));
var _throttle = _interopRequireDefault(require("lodash/throttle"));
var _focusTrapUtils = require("../../__internal__/focus-trap/focus-trap-utils");
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _anchorNavigation = require("./anchor-navigation.style");
var _anchorNavigationItem = _interopRequireDefault(require("./anchor-navigation-item/anchor-navigation-item.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SECTION_VISIBILITY_OFFSET = 200;
const SCROLL_THROTTLE = 100;
const AnchorNavigation = ({
  children,
  stickyNavigation
}) => {
  !(0, _reactIs.isFragment)(stickyNavigation) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "`stickyNavigation` prop in `AnchorNavigation` should be a React Fragment.") : (0, _invariant.default)(false) : void 0;
  const hasCorrectItemStructure = (0, _react.useMemo)(() => {
    const incorrectChild = _react.default.Children.toArray(stickyNavigation.props.children).find(child => {
      return ! /*#__PURE__*/_react.default.isValidElement(child) || child.type.displayName !== _anchorNavigationItem.default.displayName;
    });
    return !incorrectChild;
  }, [stickyNavigation]);
  !hasCorrectItemStructure ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `\`stickyNavigation\` prop in \`AnchorNavigation\` should be a React Fragment that only contains children of type \`${_anchorNavigationItem.default.displayName}\``) : (0, _invariant.default)(false) : void 0;
  const [selectedIndex, setSelectedIndex] = (0, _react.useState)(0);
  const sectionRefs = (0, _react.useRef)(_react.default.Children.map(stickyNavigation.props.children, child => child.props.target));
  const contentRef = (0, _react.useRef)(null);
  const navigationRef = (0, _react.useRef)(null);
  const isUserScroll = (0, _react.useRef)(true);
  const isUserScrollTimer = (0, _react.useRef)();
  const setSelectedAnchorBasedOnScroll = (0, _react.useCallback)(() => {
    // istanbul ignore if
    // function is called only after component is rendered, so ref cannot hold a null value
    if (navigationRef.current === null) return;
    const offsetsWithIndexes = sectionRefs.current.map(({
      current
    }, index) => [index, current?.getBoundingClientRect().top]).filter(offsetWithIndex => offsetWithIndex[1] !== undefined);
    const {
      top: navTopOffset
    } = navigationRef.current.getBoundingClientRect();
    const indexOfSmallestNegativeTopOffset = offsetsWithIndexes.reduce((currentTopIndex, offsetWithIndex) => {
      const [index, offset] = offsetWithIndex;
      if (offset - SECTION_VISIBILITY_OFFSET > navTopOffset) return currentTopIndex;
      return offset > offsetsWithIndexes[currentTopIndex][1] ? index : currentTopIndex;
    }, offsetsWithIndexes[0][0]);
    setSelectedIndex(indexOfSmallestNegativeTopOffset);
  }, []);
  const scrollHandler = (0, _react.useMemo)(() => (0, _throttle.default)(() => {
    if (isUserScroll.current) {
      setSelectedAnchorBasedOnScroll();
    } else {
      if (isUserScrollTimer.current !== undefined) {
        window.clearTimeout(isUserScrollTimer.current);
      }
      isUserScrollTimer.current = setTimeout( /* istanbul ignore next */() => {
        isUserScroll.current = true;
      }, SCROLL_THROTTLE + 50);
    }
  }, SCROLL_THROTTLE), [setSelectedAnchorBasedOnScroll]);
  (0, _react.useEffect)(() => {
    window.addEventListener("scroll", scrollHandler, true);
    return () => window.removeEventListener("scroll", scrollHandler, true);
  }, [scrollHandler]);
  const focusSection = section => {
    if (!section.matches(_focusTrapUtils.defaultFocusableSelectors)) {
      section.setAttribute("tabindex", "-1");
    }
    section.focus({
      preventScroll: true
    });
  };
  const scrollToSection = index => {
    const sectionToScroll = sectionRefs.current[index].current;

    // istanbul ignore if
    // function is called only after component is rendered, so ref cannot hold a null value
    if (sectionToScroll === null) return;

    // ensure section has the appropriate element to remove the default focus styles.
    // Can ignore else branch because there's no harm in setting this to "true" twice (it can't hold any other value),
    // but it's probably more efficient not to.
    // istanbul ignore else
    if (!sectionToScroll.dataset.carbonAnchornavRef) {
      sectionToScroll.dataset.carbonAnchornavRef = "true";
    }
    focusSection(sectionToScroll);

    // workaround due to preventScroll focus method option on firefox not working consistently
    window.setTimeout(() => {
      isUserScroll.current = false;
      sectionToScroll.scrollIntoView({
        block: "start",
        inline: "nearest",
        behavior: "smooth"
      });
      setSelectedIndex(index);
    }, 10);
  };
  const handleClick = (event, index) => {
    event.preventDefault();
    scrollToSection(index);
  };
  const handleKeyDown = (event, index) => {
    if (_events.default.isEnterKey(event)) {
      scrollToSection(index);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_anchorNavigation.StyledAnchorNavigation, {
    ref: contentRef,
    "data-component": "anchor-navigation"
  }, /*#__PURE__*/_react.default.createElement(_anchorNavigation.StyledNavigation, {
    ref: navigationRef,
    "data-element": "anchor-sticky-navigation"
  }, _react.default.Children.map(stickyNavigation.props.children, (child, index) => /*#__PURE__*/_react.default.cloneElement(child, {
    href: child.props.href || "#",
    // need to pass an href to ensure the link is tabbable by default
    isSelected: index === selectedIndex,
    onClick: event => handleClick(event, index),
    onKeyDown: event => handleKeyDown(event, index)
  }))), /*#__PURE__*/_react.default.createElement(_anchorNavigation.StyledContent, null, children));
};
if (process.env.NODE_ENV !== "production") {
  AnchorNavigation.propTypes = {
    "children": _propTypes.default.node,
    "stickyNavigation": _propTypes.default.node
  };
}
AnchorNavigation.displayName = "AnchorNavigation";
var _default = exports.default = AnchorNavigation;