"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _anchorNavigationItem = _interopRequireDefault(require("./anchor-navigation-item.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const AnchorNavigationItem = /*#__PURE__*/_react.default.forwardRef(({
  children,
  onKeyDown,
  onClick,
  href,
  tabIndex,
  isSelected
}, ref) => /*#__PURE__*/_react.default.createElement(_anchorNavigationItem.default, {
  isSelected: isSelected
}, /*#__PURE__*/_react.default.createElement("a", {
  onKeyDown: onKeyDown,
  onClick: onClick,
  tabIndex: tabIndex,
  ref: ref,
  href: href,
  "data-element": "anchor-navigation-item"
}, children)));
if (process.env.NODE_ENV !== "production") {
  AnchorNavigationItem.propTypes = {
    "children": _propTypes.default.node,
    "href": _propTypes.default.string,
    "isSelected": _propTypes.default.bool,
    "onClick": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "tabIndex": _propTypes.default.number,
    "target": _propTypes.default.shape({
      "current": _propTypes.default.oneOfType([_propTypes.default.oneOf([null]), function (props, propName) {
        if (props[propName] == null) {
          return new Error("Prop '" + propName + "' is required but wasn't specified");
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }]).isRequired
    })
  };
}
AnchorNavigationItem.displayName = "AnchorNavigationItem";
var _default = exports.default = AnchorNavigationItem;