"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HiddenCurrentColorList = exports.DialogStyle = void 0;
Object.defineProperty(exports, "StyledAdvancedColorPickerCell", {
  enumerable: true,
  get: function () {
    return _advancedColorPickerCell.default;
  }
});
exports.StyledAdvancedColorPickerWrapper = exports.StyledAdvancedColorPickerPreview = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _advancedColorPickerCell = _interopRequireDefault(require("./advanced-color-picker-cell.style"));
var _simpleColorPicker = require("../simple-color-picker/simple-color-picker.style");
var _simpleColor = require("../simple-color-picker/simple-color/simple-color.style");
var _dialog = require("../dialog/dialog.style");
var _dialog2 = _interopRequireDefault(require("../dialog/dialog.component"));
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
var _checkerBoard = _interopRequireDefault(require("../simple-color-picker/simple-color/checker-board.svg"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _visuallyHidden = _interopRequireDefault(require("../../style/utils/visually-hidden"));
var _definitionList = require("../definition-list");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledAdvancedColorPickerWrapper = exports.StyledAdvancedColorPickerWrapper = _styledComponents.default.div`
  ${_styledSystem.margin}
  display: inline-block;
`;

/** To be replaced by accessibly hidden class added in FE-5503 */
const HiddenCurrentColorList = exports.HiddenCurrentColorList = (0, _styledComponents.default)(_definitionList.Dl)`
  ${_visuallyHidden.default}
`;
StyledAdvancedColorPickerWrapper.defaultProps = {
  theme: _base.default
};
const StyledAdvancedColorPickerPreview = exports.StyledAdvancedColorPickerPreview = _styledComponents.default.div`
  width: 25px;
  height: 25px;
  margin-bottom: 15px;
  border: 1px solid var(--colorsUtilityYin090);
  border-radius: var(--borderRadius050);

  ${({
  color
}) => color !== "transparent" && (0, _styledComponents.css)`
      background-color: ${color};
    `}

  ${({
  color
}) => color === "transparent" && (0, _styledComponents.css)`
      background-color: #eeeeee;
      background-image: url(${_checkerBoard.default});
      background-size: 10px 10px;
    `}

  &:hover {
    cursor: initial;
  }
`;
const DialogStyle = exports.DialogStyle = (0, _styledComponents.default)(_dialog2.default)`
  ${_dialog.StyledDialogContent} {
    padding: var(--spacing200);
  }

  ${_dialog.StyledDialogInnerContent} {
    padding: 0;
  }

  ${_simpleColorPicker.StyledColorOptions} {
    max-width: 285px;
    ${_simpleColor.StyledSimpleColor} {
      border: 1px solid var(--colorsUtilityYin090);
      margin-right: -1px;
      margin-bottom: -1px;
      transition: all 0.2s ease;

      &:hover {
        transform: scale(1.1);
      }
    }
  }

  ${_simpleColorPicker.StyledColorOptions} {
    border: none;
  }

  ${_iconButton.default} {
    top: 20px;
    right: 13px;
  }

  [data-component="icon"] {
    color: var(--colorsActionMinor500);
  }
`;