"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AdvancedColorPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _advancedColorPicker = require("./advanced-color-picker.style");
var _simpleColorPicker = require("../simple-color-picker");
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _utils = require("../../style/utils");
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _definitionList = require("../definition-list");
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
const AdvancedColorPicker = ({
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  availableColors,
  defaultColor,
  name,
  onOpen,
  onClose,
  onChange,
  onBlur,
  open = false,
  role,
  selectedColor,
  ...props
}) => {
  const [dialogOpen, setDialogOpen] = (0, _react.useState)();
  const currentColor = selectedColor || defaultColor;
  const [selectedColorRef, setSelectedColorRef] = (0, _react.useState)(null);
  const descriptionId = (0, _react.useRef)((0, _guid.default)());
  const l = (0, _useLocale.default)();
  const simpleColorPickerData = (0, _react.useRef)(null);
  const colors = availableColors.map(({
    value,
    label
  }, index) => {
    return {
      value,
      label,
      getRef: () => /* Fallback to null to satisfy the TypeScript compiler */
      /* istanbul ignore next */
      simpleColorPickerData.current ? simpleColorPickerData.current.gridItemRefs[index] : null
    };
  });
  const currentSelectedColor = () => {
    const returnedColor = availableColors.find(color => color.value === currentColor)?.label;
    return returnedColor || currentColor;
  };
  (0, _react.useEffect)(() => {
    if (dialogOpen || open) {
      const newColor = colors?.find(c => currentColor === c.value);

      /* istanbul ignore else */
      if (newColor) {
        setSelectedColorRef(newColor.getRef());
      }
    }
  }, [colors, currentColor, dialogOpen, open]);
  const handleFocus = (0, _react.useCallback)((e, firstFocusableElement) => {
    /* istanbul ignore else */
    if (e.key === "Tab") {
      if (e.shiftKey) {
        if (document.activeElement === firstFocusableElement && selectedColorRef) {
          selectedColorRef.focus();
          e.preventDefault();
        }
      } else if (document.activeElement === selectedColorRef) {
        firstFocusableElement.focus();
        e.preventDefault();
      }
    }
  }, [selectedColorRef]);
  const handleOnOpen = (0, _react.useCallback)(e => {
    setDialogOpen(true);
    if (onOpen) {
      onOpen(e);
    }
  }, [onOpen]);
  const handleOnClose = (0, _react.useCallback)(e => {
    setDialogOpen(false);
    if (onClose) {
      onClose(e);
    }
  }, [onClose]);
  const handleOnChange = (0, _react.useCallback)(e => {
    const newColor = colors?.find(c => e.target.value === c.value);

    /* istanbul ignore else */
    if (newColor) {
      setSelectedColorRef(newColor.getRef());
    }

    /* istanbul ignore else */
    if (onChange) {
      onChange(e);
    }
  }, [onChange, colors]);
  const handleOnKeyDown = (0, _react.useCallback)(e => {
    if (_events.default.isEnterKey(e) || _events.default.isSpaceKey(e)) {
      e.preventDefault();
      handleOnOpen(e);
    }
  }, [handleOnOpen]);
  const handleColorOnKeyDown = (0, _react.useCallback)(e => {
    if (_events.default.isEnterKey(e) || _events.default.isSpaceKey(e)) {
      e.preventDefault();
      handleOnClose(e);
    }
  }, [handleOnClose]);
  const handleOnBlur = (0, _react.useCallback)(e => {
    if (onBlur) {
      onBlur(e);
    }
  }, [onBlur]);
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Advanced Color Picker` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/_react.default.createElement(_advancedColorPicker.StyledAdvancedColorPickerWrapper, _extends({
    m: "15px auto auto 15px"
  }, (0, _utils.filterStyledSystemMarginProps)(props)), /*#__PURE__*/_react.default.createElement(_advancedColorPicker.StyledAdvancedColorPickerCell, {
    "data-element": "color-picker-cell",
    "aria-label": l.advancedColorPicker.ariaLabel(),
    "aria-describedby": descriptionId.current,
    onClick: handleOnOpen,
    onKeyDown: handleOnKeyDown,
    color: currentColor,
    tabIndex: 0
  }), /*#__PURE__*/_react.default.createElement(_advancedColorPicker.HiddenCurrentColorList, {
    id: descriptionId.current,
    "data-element": "current-color-description"
  }, /*#__PURE__*/_react.default.createElement(_definitionList.Dt, null, l.advancedColorPicker.currentColorDescriptionTerm(currentSelectedColor())), /*#__PURE__*/_react.default.createElement(_definitionList.Dd, null, l.advancedColorPicker.currentColorAssigned(currentSelectedColor()))), /*#__PURE__*/_react.default.createElement(_advancedColorPicker.DialogStyle, {
    "aria-describedby": ariaDescribedBy,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    open: dialogOpen || open,
    size: "auto",
    onCancel: handleOnClose,
    bespokeFocusTrap: handleFocus,
    focusFirstElement: selectedColorRef,
    role: role
  }, /*#__PURE__*/_react.default.createElement(_advancedColorPicker.StyledAdvancedColorPickerPreview, {
    "data-element": "color-picker-preview",
    color: currentColor
  }), /*#__PURE__*/_react.default.createElement(_simpleColorPicker.SimpleColorPicker, {
    name: name,
    legend: "",
    onChange: handleOnChange,
    onBlur: handleOnBlur,
    onKeyDown: handleColorOnKeyDown,
    ref: simpleColorPickerData
  }, colors?.map(({
    value,
    label
  }) => /*#__PURE__*/_react.default.createElement(_simpleColorPicker.SimpleColor, {
    value: value,
    key: value,
    "aria-label": label,
    id: value,
    defaultChecked: value === currentColor
  })))));
};
exports.AdvancedColorPicker = AdvancedColorPicker;
var _default = exports.default = AdvancedColorPicker;