"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const transparentSvg = "%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%" + "2Fsvg%22%20width%3D%22400%22%20height%3D%22400%22%20fill-opacity%3D%22." + "45%22%3E%3Crect%20x%3D%22200%22%20width%3D%22200%22%20height%3D%22200%22%20%2" + "F%3E%3Crect%20y%3D%22200%22%20width%3D%22200%22%20height%3D%22200%22%20%2F%3E%3C%2Fsvg%3E";
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledAdvancedColorPickerCell = _styledComponents.default.button.attrs({
  type: "button"
})`
  display: block;
  width: 25px;
  height: 25px;
  border: 1px solid var(--colorsUtilityYin090);
  ${({
  color
}) => color && (0, _styledComponents.css)`
      background-color: ${color};
      border-radius: var(--borderRadius050);
    `}

  ${({
  color
}) => color === "transparent" && (0, _styledComponents.css)`
      background: #eee url("data:image/svg+xml,${transparentSvg}");
      background-size: 10px 10px;
    `}

  &:hover {
    cursor: pointer;
  }

  &:focus {
    ${({
  theme
}) => `
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
    `}
  }

  &::-moz-focus-inner {
    border: none;
  }
`;
StyledAdvancedColorPickerCell.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledAdvancedColorPickerCell;