"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubMenuItemIcon = exports.StyledMenuItemWrapper = exports.StyledMenuItemOuterContainer = exports.StyledMenuItemInnerText = exports.StyledMenuItem = exports.StyledButtonIcon = exports.MenuItemIcon = exports.MenuItemDivider = exports.MenuButtonOverrideWrapper = exports.MenuButton = exports.Menu = exports.ButtonIcon = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _icon = _interopRequireDefault(require("../icon"));
var _icon2 = _interopRequireDefault(require("../icon/icon.style"));
var _button = _interopRequireDefault(require("../button/button.style"));
var _browserTypeCheck = require("../../__internal__/utils/helpers/browser-type-check");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const Menu = exports.Menu = _styledComponents.default.ul`
  ${({
  isOpen
}) => isOpen ? "display: block;" : "visibility: hidden;"}
  margin: 0;
  list-style: none;
  padding: var(--spacing100) 0;
  box-shadow: var(--boxShadow100);
  position: absolute;
  border-radius: var(--borderRadius100);
  background-color: var(--colorsUtilityYang100);
  z-index: ${({
  theme
}) => `${theme.zIndex?.popover}`}; // TODO (tokens): implement elevation tokens - FE-4437
`;
function getPaddingValues(childHasSubmenu, childHasIcon, hasIcon, hasSubmenu) {
  if (!childHasIcon && childHasSubmenu && !hasIcon && !hasSubmenu) {
    return "var(--spacing400)";
  }
  if (childHasIcon && childHasSubmenu && !hasIcon && hasSubmenu) {
    return "var(--spacing600)";
  }
  if (childHasIcon && childHasSubmenu && !hasIcon && !hasSubmenu) {
    return "var(--spacing900)";
  }
  return "var(--spacing100)";
}
function getIconPaddingValues(index, horizontalAlignment, submenuPosition, siblingsHaveIconAndSubmenu, isASubmenu) {
  const sameAlignment = horizontalAlignment === "left" && submenuPosition === "left" || horizontalAlignment === "right" && submenuPosition === "right";
  if (siblingsHaveIconAndSubmenu && sameAlignment) {
    if (horizontalAlignment === "left") {
      return index === 1 ? "var(--spacing100)" : "var(--spacing400)";
    }
    return index === 1 ? "var(--spacing400)" : "var(--spacing100)";
  }
  if (isASubmenu) {
    if (horizontalAlignment === "left") {
      return index === 1 ? "var(--spacing100)" : "var(--spacing000)";
    }
    return index === 1 ? "var(--spacing000)" : "var(--spacing100)";
  }
  return "var(--spacing100)";
}
const StyledMenuItemInnerText = exports.StyledMenuItemInnerText = _styledComponents.default.div`
  ${({
  childHasSubmenu,
  childHasIcon,
  hasIcon,
  hasSubmenu,
  submenuPosition,
  horizontalAlignment,
  isASubmenu
}) => (0, _styledComponents.css)`
    padding-left: ${isASubmenu ? `var(--spacing000)` : `var(--spacing100)`};
    padding-right: ${isASubmenu ? `var(--spacing000)` : `var(--spacing100)`};

    ${horizontalAlignment === "left" && submenuPosition === "left" && !isASubmenu && (0, _styledComponents.css)`
      padding-left: ${getPaddingValues(childHasSubmenu, childHasIcon, hasIcon, hasSubmenu)};
    `}

    ${horizontalAlignment === "right" && submenuPosition === "right" && !isASubmenu && (0, _styledComponents.css)`
      padding-right: ${getPaddingValues(childHasSubmenu, childHasIcon, hasIcon, hasSubmenu)};
    `}
  `}
`;
const StyledMenuItemOuterContainer = exports.StyledMenuItemOuterContainer = _styledComponents.default.div`
  display: inherit;
`;
const StyledMenuItem = exports.StyledMenuItem = _styledComponents.default.button`
  ${({
  horizontalAlignment,
  submenuPosition,
  childHasSubmenu,
  hasSubmenu
}) => (0, _styledComponents.css)`
      justify-content: ${horizontalAlignment === "left" ? "flex-start" : "flex-end"};

      ${horizontalAlignment === "left" && submenuPosition === "right" && (0, _styledComponents.css)`
        justify-content: space-between;
      `}

      ${horizontalAlignment === "right" && submenuPosition === "left" && (0, _styledComponents.css)`
        ${childHasSubmenu && hasSubmenu && (0, _styledComponents.css)`
          justify-content: space-between;
        `}
      `}
    `}

  text-decoration: none;
  background-color: var(--colorsActionMajorYang100);
  cursor: pointer;
  box-sizing: border-box;
  padding: 0 var(--spacing150);
  position: relative;
  line-height: 40px;
  white-space: nowrap;
  user-select: none;
  display: flex;
  align-items: center;
  border: none;
  width: 100%;
  color: var(--colorsUtilityYin090);
  font-size: 14px;
  font-weight: 700;

  &:focus {
    ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
    z-index: 1;
    border-radius: var(--borderRadius000);
  }

  ${({
  isDisabled
}) => isDisabled && (0, _styledComponents.css)`
      color: var(--colorsUtilityYin030);
      cursor: not-allowed;

      && ${_icon2.default} {
        cursor: not-allowed;
        color: var(--colorsUtilityYin030);
      }

      :focus {
        border: none;
        outline: none;
        -webkit-appearance: none;
        -webkit-box-shadow: none;
        box-shadow: none;
      }
    `}

  ${({
  isDisabled
}) => !isDisabled && (0, _styledComponents.css)`
      &:focus,
      &:hover {
        background-color: var(--colorsUtilityMajor100);
      }
      && ${_icon2.default} {
        cursor: pointer;
      }
    `}
`;
StyledMenuItem.defaultProps = {
  theme: _base.default
};
const StyledMenuItemWrapper = exports.StyledMenuItemWrapper = _styledComponents.default.li`
  position: relative;
`;
const MenuItemDivider = exports.MenuItemDivider = _styledComponents.default.li.attrs({
  "data-element": "action-popover-divider"
})`
  background-color: var(--colorsUtilityMajor050);
  height: var(--borderWidth100);
  margin: var(--spacing100) var(--spacing150);
`;
const MenuButton = exports.MenuButton = _styledComponents.default.div`
  position: relative;
  && ${_icon2.default} {
    cursor: pointer;
  }
  width: fit-content;
  margin: auto;
  ${_styledSystem.margin}
`;
const ButtonIcon = exports.ButtonIcon = (0, _styledComponents.default)(_icon.default)`
  color: var(--colorsActionMinor500);

  :hover {
    color: var(--colorsActionMinor600);
  }
`;
const StyledButtonIcon = exports.StyledButtonIcon = _styledComponents.default.div`
  ${({
  theme
}) => `
    &:focus {
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
    }    
  `}
  border-radius: var(--borderRadius050);
`;
const MenuItemIcon = exports.MenuItemIcon = (0, _styledComponents.default)(_icon.default)`
  ${({
  horizontalAlignment,
  submenuPosition,
  childHasIcon,
  childHasSubmenu,
  hasIcon,
  hasSubmenu,
  isASubmenu
}) => (0, _styledComponents.css)`
    justify-content: ${horizontalAlignment};
    padding: var(--spacing100)
      ${getIconPaddingValues(1, horizontalAlignment, submenuPosition, childHasIcon && childHasSubmenu && hasIcon && !hasSubmenu, isASubmenu)}
      var(--spacing100)
      ${getIconPaddingValues(2, horizontalAlignment, submenuPosition, childHasIcon && childHasSubmenu && hasIcon && !hasSubmenu, isASubmenu)};
    color: var(--colorsUtilityYin065);
  `}
`;
StyledButtonIcon.defaultProps = {
  theme: _base.default
};
const SubMenuItemIcon = exports.SubMenuItemIcon = (0, _styledComponents.default)(ButtonIcon)`
  ${({
  type
}) => (0, _styledComponents.css)`
    ${type === "chevron_left_thick" && (0, _styledComponents.css)`
      left: -5px;
    `}

    ${type === "chevron_right_thick" && (0, _styledComponents.css)`
      right: -5px;
      ${(0, _browserTypeCheck.isSafari)(navigator) && (0, _styledComponents.css)`
        top: var(--sizing100);
      `}
    `}
  `}
`;
const MenuButtonOverrideWrapper = exports.MenuButtonOverrideWrapper = _styledComponents.default.div`
  ${_button.default} {
    padding: 0px var(--sizing100);
    width: 100%;

    &:hover,
    &:focus {
      background-color: var(--colorsActionMajorTransparent);
      color: var(--colorsActionMajor600);

      span[color] {
        color: var(--colorsActionMajor600);
      }
    }
  }
`;