"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ActionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _actionPopover = require("./action-popover.style");
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _popover = _interopRequireDefault(require("../../__internal__/popover"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _actionPopoverMenu = _interopRequireDefault(require("./action-popover-menu/action-popover-menu.component"));
var _actionPopoverItem = _interopRequireDefault(require("./action-popover-item/action-popover-item.component"));
var _actionPopoverDivider = _interopRequireDefault(require("./action-popover-divider/action-popover-divider.component"));
var _actionPopoverContext = _interopRequireDefault(require("./action-popover-context"));
var _useModalManager = _interopRequireDefault(require("../../hooks/__internal__/useModalManager"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const onOpenDefault = () => {};
const onCloseDefault = () => {};
const ActionPopover = ({
  children,
  id,
  onOpen = onOpenDefault,
  onClose = onCloseDefault,
  rightAlignMenu,
  renderButton,
  placement = "bottom",
  horizontalAlignment = "left",
  submenuPosition = "left",
  "aria-label": ariaLabel,
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const [isOpen, setOpenState] = (0, _react.useState)(false);
  const [focusIndex, setFocusIndex] = (0, _react.useState)(0);
  const [guid] = (0, _react.useState)((0, _guid.default)());
  const buttonRef = (0, _react.useRef)(null);
  const menu = (0, _react.useRef)(null);
  const itemCount = (0, _react.useMemo)(() => {
    return _react.default.Children.toArray(children).filter(child => {
      return /*#__PURE__*/_react.default.isValidElement(child) && child.type === _actionPopoverItem.default;
    }).length;
  }, [children]);
  const hasProperChildren = (0, _react.useMemo)(() => {
    const incorrectChild = _react.default.Children.toArray(children).find(child => {
      if (! /*#__PURE__*/_react.default.isValidElement(child)) {
        return true;
      }
      return child.type !== _actionPopoverItem.default && child.type !== _actionPopoverDivider.default;
    });
    return !incorrectChild;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `ActionPopover only accepts children of type \`${_actionPopoverItem.default.displayName}\`` + ` and \`${_actionPopoverDivider.default.displayName}\`.`) : (0, _invariant.default)(false) : void 0;
  const mappedPlacement = (0, _react.useMemo)(() => {
    if (placement === "top" && !rightAlignMenu) {
      return "top-end";
    }
    if (placement === "top" && rightAlignMenu) {
      return "top-start";
    }
    if (placement === "bottom" && rightAlignMenu) {
      return "bottom-start";
    }
    return "bottom-end";
  }, [placement, rightAlignMenu]);
  const setOpen = (0, _react.useCallback)(value => {
    if (value && !isOpen) {
      onOpen();
    }
    if (!value && isOpen) {
      onClose();
    }
    setOpenState(value);
  }, [isOpen, onOpen, onClose]);
  const focusButton = (0, _react.useCallback)(() => {
    const button = buttonRef.current?.querySelector("[data-element='action-popover-button']");
    button?.focus();
  }, []);
  const onButtonClick = (0, _react.useCallback)(e => {
    e.stopPropagation();
    const isOpening = !isOpen;
    setOpen(isOpening);
    if (!isOpening) {
      // Closing the menu should focus the MenuButton
      focusButton();
    }
  }, [isOpen, setOpen, focusButton]);

  // Keyboard commands implemented as recommended by WAI-ARIA best practices
  // https://www.w3.org/TR/wai-aria-practices/examples/menu-button/menu-button-actions.html

  const onButtonKeyDown = (0, _react.useCallback)(e => {
    if (_events.default.isSpaceKey(e) || _events.default.isDownKey(e) || _events.default.isEnterKey(e)) {
      e.preventDefault();
      e.stopPropagation();
      setFocusIndex(0);
      setOpen(true);
    } else if (_events.default.isUpKey(e)) {
      e.preventDefault();
      e.stopPropagation();
      setFocusIndex(itemCount - 1);
      setOpen(true);
    }
  }, [itemCount, setOpen]);
  const handleEscapeKey = (0, _react.useCallback)(e => {
    /* istanbul ignore else */
    if (_events.default.isEscKey(e)) {
      setOpen(false);
      focusButton();
    }
  }, [setOpen, focusButton]);
  (0, _useModalManager.default)({
    open: isOpen,
    closeModal: handleEscapeKey,
    modalRef: buttonRef
  });
  (0, _react.useEffect)(() => {
    const handler = ({
      target
    }) => {
      // If the event didn't came from part of this component, close the menu.
      // There will be multiple document click listeners but we cant prevent propagation because it will interfere with
      // other instances on the same page

      const isInMenu = menu?.current?.contains(target);
      const isInButton = buttonRef?.current?.contains(target);
      if (!isInMenu && !isInButton) {
        setOpen(false);
      }
    };
    const event = "click";
    document.addEventListener(event, handler, {
      capture: true
    });
    return function cleanup() {
      document.removeEventListener(event, handler, {
        capture: true
      });
    };
  }, [setOpen]);
  const menuButton = menuID => {
    if (renderButton) {
      return renderButton({
        tabIndex: isOpen ? -1 : 0,
        "data-element": "action-popover-button",
        ariaAttributes: {
          "aria-haspopup": "true",
          "aria-label": ariaLabel || l.actionPopover.ariaLabel(),
          "aria-controls": menuID,
          "aria-expanded": `${isOpen}`
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_actionPopover.StyledButtonIcon, {
      role: "button",
      "aria-haspopup": "true",
      "aria-label": ariaLabel || l.actionPopover.ariaLabel(),
      "aria-controls": menuID,
      "aria-expanded": isOpen,
      tabIndex: isOpen ? -1 : 0,
      "data-element": "action-popover-button"
    }, /*#__PURE__*/_react.default.createElement(_actionPopover.ButtonIcon, {
      type: "ellipsis_vertical"
    }));
  };
  const parentID = id || `ActionPopoverButton_${guid}`;
  const menuID = `ActionPopoverMenu_${guid}`;
  const menuProps = {
    buttonRef,
    parentID,
    setFocusIndex,
    focusIndex,
    menuID,
    isOpen,
    setOpen,
    rightAlignMenu,
    placement,
    horizontalAlignment
  };
  return /*#__PURE__*/_react.default.createElement(_actionPopover.MenuButton, _extends({
    id: parentID,
    "data-component": "action-popover-wrapper",
    onKeyDown: onButtonKeyDown,
    onClick: onButtonClick,
    isOpen,
    ref: buttonRef
  }, rest), menuButton(menuID), /*#__PURE__*/_react.default.createElement(_actionPopoverContext.default.Provider, {
    value: {
      setOpenPopover: setOpen,
      focusButton,
      submenuPosition,
      isOpenPopover: isOpen
    }
  }, isOpen && /*#__PURE__*/_react.default.createElement(_popover.default, {
    placement: mappedPlacement,
    reference: buttonRef
  }, /*#__PURE__*/_react.default.createElement(_actionPopoverMenu.default, _extends({
    "data-component": "action-popover",
    ref: menu
  }, menuProps), children))));
};
exports.ActionPopover = ActionPopover;
var _default = exports.default = ActionPopover;