"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _actionPopover = require("../action-popover.style");
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _actionPopoverItem = _interopRequireDefault(require("../action-popover-item/action-popover-item.component"));
var _actionPopoverDivider = _interopRequireDefault(require("../action-popover-divider/action-popover-divider.component"));
var _actionPopoverContext = _interopRequireDefault(require("../action-popover-context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ActionPopoverMenu = /*#__PURE__*/_react.default.forwardRef(({
  children,
  parentID,
  focusIndex,
  isOpen,
  menuID,
  setOpen,
  setFocusIndex,
  placement = "bottom",
  horizontalAlignment,
  isASubmenu,
  ...rest
}, ref) => {
  const context = (0, _react.useContext)(_actionPopoverContext.default);
  !context ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "ActionPopoverMenu must be used within an ActionPopover component") : (0, _invariant.default)(false) : void 0;
  const {
    focusButton,
    submenuPosition
  } = context;
  !(setOpen && setFocusIndex && typeof focusIndex !== "undefined") ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "ActionPopoverMenu must be used within an ActionPopover or ActionPopoverItem component") : (0, _invariant.default)(false) : void 0;
  const hasProperChildren = (0, _react.useMemo)(() => {
    const incorrectChild = _react.default.Children.toArray(children).find(child => {
      if (! /*#__PURE__*/_react.default.isValidElement(child)) {
        return true;
      }
      return child.type.displayName !== _actionPopoverItem.default.displayName && child.type.displayName !== _actionPopoverDivider.default.displayName;
    });
    return !incorrectChild;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `ActionPopoverMenu only accepts children of type \`${_actionPopoverItem.default.displayName}\`` + ` and \`${_actionPopoverDivider.default.displayName}\`.`) : (0, _invariant.default)(false) : void 0;
  const items = (0, _react.useMemo)(() => {
    return _react.default.Children.toArray(children).filter(child => {
      return /*#__PURE__*/_react.default.isValidElement(child) && child.type === _actionPopoverItem.default;
    });
  }, [children]);
  const isItemDisabled = (0, _react.useCallback)(value => {
    const item = items[value];
    // The invariant will be triggered before this else path can be explored, hence the ignore else.
    // istanbul ignore else
    return /*#__PURE__*/_react.default.isValidElement(item) && item.props.disabled;
  }, [items]);
  const firstFocusableItem = items.findIndex((_, index) => !isItemDisabled(index));

  // FIX-ME: FE-6248
  // Once we no longer support Node 16, this function can be removed and `findLastIndex()` can be used in it's place.
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findLastIndex
  function findLastFocusableItem() {
    let lastFocusableItem = -1;
    for (let i = items.length - 1; i >= 0; i--) {
      if (!isItemDisabled(i)) {
        lastFocusableItem = i;
        break;
      }
    }
    return lastFocusableItem;
  }
  const lastFocusableItem = findLastFocusableItem();
  (0, _react.useEffect)(() => {
    if (isOpen && firstFocusableItem !== -1) setFocusIndex(firstFocusableItem);
  }, [isOpen, firstFocusableItem, setFocusIndex]);
  const onKeyDown = (0, _react.useCallback)(e => {
    if (_events.default.isTabKey(e)) {
      e.preventDefault();
      // TAB: close menu and allow focus to change to the next focusable element
      focusButton();
      setOpen(false);
    } else if (_events.default.isDownKey(e)) {
      // DOWN: focus on the next item or first non-disabled item
      e.preventDefault();
      e.stopPropagation();
      let indexValue = focusIndex + 1;
      while (indexValue < items.length && isItemDisabled(indexValue)) {
        indexValue += 1;
      }
      if (indexValue >= items.length) {
        indexValue = firstFocusableItem;
      }
      setFocusIndex(indexValue);
    } else if (_events.default.isUpKey(e)) {
      // UP: focus on the previous item or last non-disabled item
      e.preventDefault();
      e.stopPropagation();
      let indexValue = focusIndex - 1;
      while (indexValue >= firstFocusableItem && isItemDisabled(indexValue)) {
        indexValue -= 1;
      }
      if (indexValue < firstFocusableItem) {
        indexValue = lastFocusableItem;
      }
      setFocusIndex(indexValue);
    } else if (_events.default.isHomeKey(e)) {
      // HOME: focus on the first non-disabled item
      e.preventDefault();
      e.stopPropagation();
      const indexValue = firstFocusableItem;
      setFocusIndex(indexValue);
    } else if (_events.default.isEndKey(e)) {
      // END: focus on the last non-disabled item
      e.preventDefault();
      e.stopPropagation();
      const indexValue = lastFocusableItem;
      setFocusIndex(indexValue);
    } else if (e.key.length === 1) {
      // Any printable character: focus on the next non-disabled item on the list that starts with that character
      // Selection should wrap to the start of the list
      e.stopPropagation();
      let firstMatch;
      let nextMatch;
      items.forEach((item, index) => {
        if ( /*#__PURE__*/_react.default.isValidElement(item) && !isItemDisabled(index) && item.props.children.toLowerCase().startsWith(e.key.toLowerCase())) {
          // istanbul ignore else
          if (firstMatch === undefined) {
            firstMatch = index;
          }
          if (index > focusIndex && nextMatch === undefined) {
            nextMatch = index;
          }
        }
      });
      if (nextMatch !== undefined) {
        setFocusIndex(nextMatch);
      } else if (firstMatch !== undefined) {
        setFocusIndex(firstMatch);
      }
    }
  }, [focusButton, setOpen, focusIndex, items, isItemDisabled, setFocusIndex, firstFocusableItem, lastFocusableItem]);
  const [childHasSubmenu, setChildHasSubmenu] = (0, _react.useState)(false);
  const [childHasIcon, setChildHasIcon] = (0, _react.useState)(false);
  const [currentSubmenuPosition, setCurrentSubmenuPosition] = (0, _react.useState)(submenuPosition);
  const clonedChildren = (0, _react.useMemo)(() => {
    let index = 0;
    return _react.default.Children.map(children, child => {
      if ( /*#__PURE__*/_react.default.isValidElement(child) && child.type === _actionPopoverItem.default) {
        index += 1;
        return /*#__PURE__*/_react.default.cloneElement(child, {
          focusItem: isOpen && focusIndex === index - 1,
          placement: child.props.submenu ? placement : undefined,
          horizontalAlignment,
          childHasSubmenu,
          setChildHasSubmenu,
          childHasIcon,
          setChildHasIcon,
          currentSubmenuPosition,
          setCurrentSubmenuPosition,
          isASubmenu
        });
      }
      return child;
    });
  }, [children, focusIndex, isOpen, placement, horizontalAlignment, childHasSubmenu, childHasIcon, currentSubmenuPosition, isASubmenu]);
  return /*#__PURE__*/_react.default.createElement(_actionPopover.Menu, _extends({
    "data-component": "action-popover",
    isOpen: isOpen,
    onKeyDown: onKeyDown,
    id: menuID,
    "aria-labelledby": parentID,
    ref: ref,
    role: "list"
  }, rest), clonedChildren);
});
if (process.env.NODE_ENV !== "production") {
  ActionPopoverMenu.propTypes = {
    "children": _propTypes.default.node,
    "data-element": _propTypes.default.string,
    "focusIndex": _propTypes.default.number,
    "horizontalAlignment": _propTypes.default.oneOf(["left", "right"]),
    "isASubmenu": _propTypes.default.bool,
    "isOpen": _propTypes.default.bool,
    "menuID": _propTypes.default.string,
    "parentID": _propTypes.default.string,
    "placement": _propTypes.default.oneOf(["bottom", "top"]),
    "role": _propTypes.default.string,
    "setFocusIndex": _propTypes.default.func,
    "setOpen": _propTypes.default.func,
    "style": _propTypes.default.shape({
      "bottom": _propTypes.default.string,
      "left": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]).isRequired,
      "right": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]).isRequired,
      "top": _propTypes.default.string
    })
  };
}
ActionPopoverMenu.displayName = "ActionPopoverMenu";
var _default = exports.default = ActionPopoverMenu;