import React from "react";
import { Alignment } from "../action-popover-context";
export interface ActionPopoverMenuBaseProps {
    /** Children for the menu */
    children?: React.ReactNode;
    /** Index to control which item is focused */
    focusIndex?: number;
    /** Flag to indicate whether a menu should open */
    isOpen?: boolean;
    /** A unique ID for the menu */
    menuID?: string;
    /** Callback to set the index of the focused item */
    setFocusIndex?: (args: number) => void;
    /** Callback to set the isOpen flag */
    setOpen?: (args: boolean) => void;
    /** Unique ID for the menu's parent */
    parentID?: string;
    /** Horizontal alignment of menu items content */
    horizontalAlignment?: Alignment;
    /** Set whether the menu should open above or below the button */
    placement?: "bottom" | "top";
    /** @ignore @private */
    role?: string;
    /** @ignore @private */
    isASubmenu?: boolean;
    /** @ignore @private */
    "data-element"?: string;
    /** @ignore @private */
    style?: {
        left: string | number;
        top?: string;
        bottom?: string;
        right: string | number;
    };
}
export interface ActionPopoverMenuProps extends ActionPopoverMenuBaseProps, React.RefAttributes<HTMLUListElement> {
}
declare const ActionPopoverMenu: React.ForwardRefExoticComponent<ActionPopoverMenuBaseProps & React.RefAttributes<HTMLUListElement>>;
export default ActionPopoverMenu;
