"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ActionPopoverItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _actionPopover = require("../action-popover.style");
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _actionPopoverContext = _interopRequireDefault(require("../action-popover-context"));
var _actionPopoverMenu = _interopRequireDefault(require("../action-popover-menu/action-popover-menu.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const INTERVAL = 150;
function checkRef(ref) {
  return Boolean(ref && ref.current);
}
function calculateSubmenuPosition(ref, submenuRef, submenuPosition, currentSubmenuPosition) {
  /* istanbul ignore if */

  if (!ref.current || !submenuRef.current) return currentSubmenuPosition || submenuPosition;
  const {
    left,
    right
  } = ref.current.getBoundingClientRect();
  const {
    offsetWidth
  } = submenuRef.current;
  const windowWidth = document.body.clientWidth;
  if (submenuPosition === "left") {
    return left >= offsetWidth ? "left" : "right";
  }
  return windowWidth >= right + offsetWidth ? "right" : "left";
}
const ActionPopoverItem = ({
  children,
  icon,
  disabled = false,
  onClick: onClickProp,
  submenu,
  placement = "bottom",
  focusItem,
  download,
  href,
  horizontalAlignment,
  childHasSubmenu,
  childHasIcon,
  currentSubmenuPosition,
  setChildHasSubmenu,
  setChildHasIcon,
  setCurrentSubmenuPosition,
  isASubmenu = false,
  ...rest
}) => {
  const context = (0, _react.useContext)(_actionPopoverContext.default);
  !context ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "ActionPopoverItem must be used within an ActionPopover component") : (0, _invariant.default)(false) : void 0;
  !( /*#__PURE__*/_react.default.isValidElement(submenu) ? submenu.type === _actionPopoverMenu.default : true) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "ActionPopoverItem only accepts submenu of type `ActionPopoverMenu`") : (0, _invariant.default)(false) : void 0;
  const {
    setOpenPopover,
    isOpenPopover,
    focusButton,
    submenuPosition
  } = context;
  const isHref = !!href;
  const [containerPosition, setContainerPosition] = (0, _react.useState)(undefined);
  const [guid] = (0, _react.useState)((0, _guid.default)());
  const [isOpen, setOpen] = (0, _react.useState)(false);
  const [focusIndex, setFocusIndex] = (0, _react.useState)(0);
  const submenuRef = (0, _react.useRef)(null);
  const ref = (0, _react.useRef)(null);
  const mouseEnterTimer = (0, _react.useRef)(null);
  const mouseLeaveTimer = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!isOpenPopover) {
      setOpen(false);
    }
  }, [isOpenPopover]);
  (0, _react.useEffect)(() => {
    if (icon) {
      setChildHasIcon?.(true);
    }
    if (submenu) {
      setChildHasSubmenu?.(true);
    }
  }, [icon, setChildHasSubmenu, setChildHasIcon, submenu]);
  const alignSubmenu = (0, _react.useCallback)(() => {
    const checkCalculatedSubmenuPosition = calculateSubmenuPosition(ref, submenuRef, submenuPosition, currentSubmenuPosition);
    setCurrentSubmenuPosition?.(checkCalculatedSubmenuPosition);
    return checkRef(ref) && checkRef(submenuRef) && submenu;
  }, [submenu, setCurrentSubmenuPosition, submenuPosition, currentSubmenuPosition]);
  (0, _react.useEffect)(() => {
    const getContainerPosition = () => {
      /* istanbul ignore if */
      if (!ref.current || !submenuRef.current) return undefined;
      const {
        offsetWidth: submenuWidth
      } = submenuRef.current;
      const leftAlignedSubmenu = currentSubmenuPosition === "left";
      const leftValue = leftAlignedSubmenu ? -submenuWidth : "auto";
      const rightValue = leftAlignedSubmenu ? "auto" : -submenuWidth;
      const yPositionName = placement === "top" ? "bottom" : "top";
      return {
        left: leftValue,
        [yPositionName]: "calc(-1 * var(--spacing100))",
        right: rightValue
      };
    };
    setContainerPosition(getContainerPosition);
  }, [submenu, currentSubmenuPosition, placement]);
  (0, _react.useEffect)(() => {
    if (submenu) {
      alignSubmenu();
    }
  }, [alignSubmenu, submenu]);

  // focuses item on opening of actionPopover submenu
  (0, _react.useEffect)(() => {
    if (focusItem) {
      ref.current?.focus({
        preventScroll: true
      });
    }
  }, [focusItem]);
  (0, _react.useEffect)(() => {
    return function cleanup() {
      if (mouseEnterTimer.current) clearTimeout(mouseEnterTimer.current);
      if (mouseLeaveTimer.current) clearTimeout(mouseLeaveTimer.current);
    };
  }, []);
  (0, _react.useEffect)(() => {
    const event = "resize";
    window.addEventListener(event, alignSubmenu);
    return function cleanup() {
      window.removeEventListener(event, alignSubmenu);
    };
  }, [alignSubmenu]);
  const onClick = (0, _react.useCallback)(e => {
    e.stopPropagation();
    if (!disabled) {
      setOpenPopover(false);
      focusButton();
      if (onClickProp) {
        onClickProp(e);
      }
    } else {
      ref.current?.focus();
      e.preventDefault();
    }
  }, [disabled, focusButton, onClickProp, setOpenPopover]);
  const onKeyDown = (0, _react.useCallback)(e => {
    if (_events.default.isSpaceKey(e)) {
      e.preventDefault();
      e.stopPropagation();
    } else if (!disabled) {
      if (submenu) {
        if (currentSubmenuPosition === "left") {
          // LEFT: open if has submenu and left aligned otherwise close submenu
          if (_events.default.isLeftKey(e) || _events.default.isEnterKey(e)) {
            setOpen(true);
            setFocusIndex(0);
            e.stopPropagation();
          } else if (_events.default.isRightKey(e)) {
            setOpen(false);
            ref.current?.focus();
            e.stopPropagation();
          }
        } else {
          // RIGHT: open if has submenu and right aligned otherwise close submenu
          if (_events.default.isRightKey(e) || _events.default.isEnterKey(e)) {
            setOpen(true);
            setFocusIndex(0);
            e.stopPropagation();
          }
          if (_events.default.isLeftKey(e)) {
            setOpen(false);
            ref.current?.focus();
            e.stopPropagation();
          }
        }
        e.preventDefault();
      } else if (_events.default.isEnterKey(e)) {
        if (isHref && download) {
          ref.current?.click();
        }
        e.preventDefault();
        // this type assertion should be safe as the onclick handler is designed to catch events propagating from the inner buttons
        onClick(e);
      }
    } else if (_events.default.isEnterKey(e)) {
      e.stopPropagation();
    }
  }, [disabled, download, isHref, onClick, submenu, currentSubmenuPosition]);
  const itemSubmenuProps = {
    ...(!disabled && {
      onClick: e => {
        setOpen(true);
        ref.current?.focus();
        e.preventDefault();
        e.stopPropagation();
      }
    }),
    "aria-haspopup": "true",
    "aria-controls": `ActionPopoverMenu_${guid}`,
    "aria-expanded": isOpen
  };
  const wrapperProps = {
    ...(!disabled && {
      onMouseEnter: e => {
        if (mouseEnterTimer.current) clearTimeout(mouseEnterTimer.current);
        setFocusIndex(-1);
        mouseEnterTimer.current = setTimeout(() => {
          setOpen(true);
        }, INTERVAL);
        e.stopPropagation();
      },
      onMouseLeave: e => {
        if (mouseLeaveTimer.current) clearTimeout(mouseLeaveTimer.current);
        mouseLeaveTimer.current = setTimeout(() => {
          setOpen(false);
        }, INTERVAL);
        e.stopPropagation();
      }
    })
  };
  const renderMenuItemIcon = () => {
    return icon && /*#__PURE__*/_react.default.createElement(_actionPopover.MenuItemIcon, {
      type: icon,
      "data-element": "action-popover-menu-item-icon",
      horizontalAlignment: horizontalAlignment,
      submenuPosition: currentSubmenuPosition,
      childHasIcon: childHasIcon,
      childHasSubmenu: childHasSubmenu,
      hasIcon: !!icon,
      hasSubmenu: !!submenu,
      isASubmenu: isASubmenu
    });
  };
  return /*#__PURE__*/_react.default.createElement(_actionPopover.StyledMenuItemWrapper, submenu && wrapperProps, /*#__PURE__*/_react.default.createElement("div", {
    onKeyDown: onKeyDown,
    role: "presentation"
  }, /*#__PURE__*/_react.default.createElement(_actionPopover.StyledMenuItem, _extends({}, rest, {
    ref: ref,
    onClick: onClick,
    type: "button",
    tabIndex: 0,
    isDisabled: disabled,
    horizontalAlignment: horizontalAlignment,
    submenuPosition: currentSubmenuPosition,
    hasSubmenu: !!submenu,
    childHasSubmenu: childHasSubmenu
  }, disabled && {
    "aria-disabled": true
  }, isHref && {
    as: "a",
    download,
    href
  }, submenu && itemSubmenuProps), submenu && checkRef(ref) && currentSubmenuPosition === "left" ? /*#__PURE__*/_react.default.createElement(_actionPopover.SubMenuItemIcon, {
    "data-element": "action-popover-menu-item-chevron",
    type: "chevron_left_thick"
  }) : null, /*#__PURE__*/_react.default.createElement(_actionPopover.StyledMenuItemOuterContainer, null, horizontalAlignment === "left" ? renderMenuItemIcon() : null, /*#__PURE__*/_react.default.createElement(_actionPopover.StyledMenuItemInnerText, {
    "data-element": "action-popover-menu-item-inner-text",
    horizontalAlignment: horizontalAlignment,
    submenuPosition: currentSubmenuPosition,
    isASubmenu: isASubmenu,
    childHasSubmenu: childHasSubmenu,
    childHasIcon: childHasIcon,
    hasIcon: !!icon,
    hasSubmenu: !!submenu
  }, children), horizontalAlignment === "right" ? renderMenuItemIcon() : null), submenu && checkRef(ref) && currentSubmenuPosition === "right" ? /*#__PURE__*/_react.default.createElement(_actionPopover.SubMenuItemIcon, {
    "data-element": "action-popover-menu-item-chevron",
    type: "chevron_right_thick"
  }) : null), /*#__PURE__*/_react.default.isValidElement(submenu) ? /*#__PURE__*/_react.default.cloneElement(submenu, {
    parentID: `ActionPopoverItem_${guid}`,
    menuID: `ActionPopoverMenu_${guid}`,
    "data-element": "action-popover-submenu",
    isOpen,
    ref: submenuRef,
    style: containerPosition,
    setOpen,
    setFocusIndex,
    focusIndex,
    isASubmenu: true,
    horizontalAlignment
  }) : null));
};
exports.ActionPopoverItem = ActionPopoverItem;
ActionPopoverItem.displayName = "ActionPopoverItem";
var _default = exports.default = ActionPopoverItem;