"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledAccordionTitleContainer = exports.StyledAccordionTitle = exports.StyledAccordionSubTitle = exports.StyledAccordionIcon = exports.StyledAccordionHeadingsContainer = exports.StyledAccordionGroup = exports.StyledAccordionContentContainer = exports.StyledAccordionContent = exports.StyledAccordionContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _icon = _interopRequireDefault(require("../icon"));
var _themes = require("../../style/themes");
var _validationIcon = _interopRequireDefault(require("../../__internal__/validations/validation-icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledAccordionGroup = exports.StyledAccordionGroup = _styledComponents.default.div`
  ${_styledSystem.margin}
`;
const StyledAccordionContainer = exports.StyledAccordionContainer = _styledComponents.default.div`
  ${_styledSystem.space}
  display: flex;
  align-items: ${({
  buttonHeading,
  variant
}) => buttonHeading || variant === "subtle" ? "flex-start" : "stretch"};
  justify-content: center;
  flex-direction: column;
  box-sizing: border-box;
  width: ${({
  width
}) => width || "100%"};
  color: var(--colorsUtilityYin090);
  background-color: ${({
  scheme,
  variant
}) => scheme === "white" && variant !== "subtle" ? "var(--colorsUtilityYang100)" : "var(--colorsUtilityMajorTransparent)"};
  border: 1px solid var(--colorsUtilityMajor100);
  ${({
  borders
}) => borders === "default" && (0, _styledComponents.css)`
      border-left: none;
      border-right: none;
    `}
  ${({
  borders
}) => borders === "none" && (0, _styledComponents.css)`
      border: none;
    `}

  ${({
  variant
}) => variant !== "subtle" && (0, _styledComponents.css)`
      & + & {
        margin-top: -1px;
        border-top: 1px solid var(--colorsUtilityMajor100);
        border-bottom: 1px solid var(--colorsUtilityMajor100);
      }
    `}
`;
const StyledAccordionTitle = exports.StyledAccordionTitle = _styledComponents.default.h3`
  font-size: ${({
  size,
  variant
}) => size === "small" || variant === "subtle" ? "var(--fontSizes200)" : "var(--fontSizes400)"};
  font-weight: 700;
  line-height: 1;
  user-select: none;
  margin: 0;
`;
const StyledAccordionSubTitle = exports.StyledAccordionSubTitle = _styledComponents.default.span`
  margin-top: 8px;
`;
const StyledAccordionIcon = exports.StyledAccordionIcon = (0, _styledComponents.default)(_icon.default)`
  transition: transform 0.3s;
  transform: rotate(0deg);
  margin-right: ${({
  iconAlign
}) => iconAlign === "left" ? "var(--spacing200)" : "var(--spacing000)"};

  ${({
  isExpanded,
  iconAlign
}) => {
  return isExpanded && (iconAlign === "right" ? "transform: rotate(180deg)" : "transform: rotate(-180deg)");
}};

  color: var(--colorsActionMinor500);
`;
const StyledAccordionHeadingsContainer = exports.StyledAccordionHeadingsContainer = _styledComponents.default.div`
  ${({
  buttonHeading,
  hasValidationIcon
}) => !buttonHeading && (0, _styledComponents.css)`
      display: grid;
      ${hasValidationIcon && (0, _styledComponents.css)`
        grid-template-columns: min-content auto;

        ${StyledAccordionSubTitle} {
          grid-column: span 3;
        }
      `}

      ${!hasValidationIcon && (0, _styledComponents.css)`
        grid-template-rows: auto auto;
      `}

    ${_validationIcon.default} {
        height: 20px;
        position: relative;
        top: 2px;
      }
    `}
`;
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledAccordionTitleContainer = exports.StyledAccordionTitleContainer = _styledComponents.default.div`
  ${({
  buttonHeading,
  buttonWidth,
  iconAlign,
  size,
  hasButtonProps,
  theme,
  isExpanded,
  variant
}) => (0, _styledComponents.css)`
    padding: ${size === "small" ? "var(--spacing200)" : "var(--spacing300)"};
    ${_styledSystem.space}
    display: flex;
    align-items: center;
    justify-content: space-between;

    ${iconAlign === "left" && (0, _styledComponents.css)`
      justify-content: flex-end;
      flex-direction: row-reverse;
    `}

    cursor: pointer;
    z-index: 1;

    &:focus {
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
    }

    ${variant === "subtle" && (0, _styledComponents.css)`
      color: var(--colorsActionMajor500);
      padding: var(--spacing025);
      margin-bottom: ${isExpanded && "var(--spacing200)"};

      ${StyledAccordionIcon} {
        color: var(--colorsActionMajor500);
        ${iconAlign === "left" && "margin-right: var(--spacing050)"};
      }

      :hover {
        color: var(--colorsActionMajor600);
        ${StyledAccordionIcon} {
          color: var(--colorsActionMajor600);
        }
      }
    `}

    ${!buttonHeading && variant !== "subtle" && (0, _styledComponents.css)`
      &:hover {
        background-color: var(--colorsUtilityMajor050);
      }
    `}

    ${buttonHeading && (0, _styledComponents.css)`
      box-sizing: border-box;
      font-weight: 600;
      text-decoration: none;
      font-size: var(--fontSizes100);
      min-height: var(--spacing500);

      color: var(--colorsActionMajor500);

      ${!hasButtonProps && (0, _styledComponents.css)`
        ${StyledAccordionHeadingsContainer} {
          margin-left: ${iconAlign === "right" ? "var(--spacing300)" : "var(--spacing100)"};
        }
      `}

      ${StyledAccordionIcon} {
        color: var(--colorsActionMajor500);
        ${!hasButtonProps && (0, _styledComponents.css)`
          position: relative;
          ${iconAlign}: 16px;
        `}
      }

      &:hover {
        color: var(--colorsActionMajor600);
        ${StyledAccordionIcon} {
          color: var(--colorsActionMajor600);
        }
      }

      ${buttonWidth && (0, _styledComponents.css)`
        width: ${typeof buttonWidth === "number" ? `${buttonWidth}px` : buttonWidth};
      `}
    `}
  `}
`;
const StyledAccordionContentContainer = exports.StyledAccordionContentContainer = _styledComponents.default.div`
  flex-grow: 1;
  box-sizing: border-box;
  overflow: hidden;
  transition: all 0.3s;
  ${({
  maxHeight,
  isExpanded
}) => (0, _styledComponents.css)`
    max-height: ${isExpanded ? `${maxHeight}px` : "0px"};
    height: ${isExpanded ? `${maxHeight}px` : "0px"};

    ${!isExpanded && `
      visibility: hidden;
    `}
  `}
`;
const StyledAccordionContent = exports.StyledAccordionContent = _styledComponents.default.div`
  padding: var(--spacing300);
  padding-top: var(--spacing100);
  overflow: hidden;

  ${({
  disableContentPadding
}) => disableContentPadding && (0, _styledComponents.css)`
      padding: 0;
    `}

  ${({
  variant
}) => variant === "subtle" && (0, _styledComponents.css)`
      margin-left: var(--spacing150);
      padding: var(--spacing100) var(--spacing200) var(--spacing300);
      border-left: 2px solid var(--colorsUtilityMajor100);
    `}
`;
StyledAccordionGroup.defaultProps = {
  theme: _themes.baseTheme
};
StyledAccordionContainer.defaultProps = {
  theme: _themes.baseTheme
};
StyledAccordionTitleContainer.defaultProps = {
  theme: _themes.baseTheme
};