"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Accordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useResizeObserver = _interopRequireDefault(require("../../hooks/__internal__/useResizeObserver"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
var _accordion = require("./accordion.style");
var _validations = _interopRequireDefault(require("../../__internal__/validations"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecatedSchemeWarnTriggered = false;
let deprecatedButtonHeadingWarnTriggered = false;
const Accordion = exports.Accordion = /*#__PURE__*/_react.default.forwardRef(({
  borders = "default",
  defaultExpanded,
  expanded,
  onChange,
  children,
  handleKeyboardAccessibility,
  id,
  index,
  iconType,
  iconAlign,
  scheme = "white",
  size = "large",
  subTitle,
  title,
  width,
  headerSpacing,
  disableContentPadding = false,
  error,
  warning,
  info,
  buttonHeading,
  buttonWidth = "150px",
  openTitle,
  variant = "standard",
  ...rest
}, ref) => {
  if (!deprecatedSchemeWarnTriggered && scheme === "transparent") {
    deprecatedSchemeWarnTriggered = true;
    _logger.default.deprecate("The `scheme` prop for `Accordion` component is deprecated and will soon be removed.");
  }
  if (!deprecatedButtonHeadingWarnTriggered && buttonHeading) {
    deprecatedButtonHeadingWarnTriggered = true;
    _logger.default.deprecate("The `buttonHeading` prop for `Accordion` component is deprecated and will soon be removed. Please use `subtle` variant instead.");
  }
  const isControlled = expanded !== undefined;
  const [isExpandedInternal, setIsExpandedInternal] = (0, _react.useState)(defaultExpanded || false);
  const [contentHeight, setContentHeight] = (0, _react.useState)(isExpandedInternal ? "auto" : 0);
  const accordionContent = (0, _react.useRef)(null);
  const isExpanded = isControlled ? expanded : isExpandedInternal;
  (0, _useResizeObserver.default)(accordionContent, () => {
    setContentHeight(accordionContent.current?.scrollHeight);
  });
  (0, _react.useEffect)(() => {
    setContentHeight(accordionContent.current?.scrollHeight);
  }, [isExpanded]);
  const toggleAccordion = (0, _react.useCallback)(ev => {
    if (!isControlled) {
      setIsExpandedInternal(!isExpanded);
    }
    if (onChange) onChange(ev, !isExpanded);
  }, [isControlled, isExpanded, onChange]);
  const handleKeyDown = (0, _react.useCallback)(ev => {
    if (handleKeyboardAccessibility) {
      handleKeyboardAccessibility(ev, index);
    }
    if (_events.default.isEnterKey(ev) || _events.default.isSpaceKey(ev)) {
      toggleAccordion(ev);
    }
  }, [handleKeyboardAccessibility, index, toggleAccordion]);
  const guid = (0, _react.useRef)((0, _guid.default)());
  const accordionId = id || `Accordion_${guid.current}`;
  const headerId = `AccordionHeader_${guid.current}`;
  const contentId = `AccordionContent_${guid.current}`;
  const showValidationIcon = !!(error || warning || info);
  const getTitle = () => isExpanded ? openTitle || title : title;
  const getIconType = () => size === "small" || variant === "subtle" ? "chevron_down_thick" : "chevron_down";
  return /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionContainer, _extends({
    id: accordionId,
    "data-component": "accordion",
    width: width,
    borders: variant === "subtle" ? "none" : borders,
    scheme: scheme,
    buttonHeading: buttonHeading,
    variant: variant
  }, rest), /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionTitleContainer, _extends({
    "data-element": "accordion-title-container",
    id: headerId,
    "aria-expanded": isExpanded,
    "aria-controls": contentId,
    onClick: toggleAccordion,
    onKeyDown: handleKeyDown,
    tabIndex: 0,
    iconAlign: iconAlign || (variant === "standard" ? "right" : "left"),
    ref: ref,
    size: size,
    buttonHeading: buttonHeading,
    isExpanded: isExpanded,
    variant: variant,
    buttonWidth: buttonWidth,
    hasButtonProps: buttonHeading && !(typeof headerSpacing === "undefined"),
    role: "button"
  }, buttonHeading && {
    p: 0
  }, headerSpacing), /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionHeadingsContainer, {
    "data-element": "accordion-headings-container",
    hasValidationIcon: showValidationIcon,
    buttonHeading: buttonHeading
  }, !buttonHeading && typeof title === "string" ? /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionTitle, {
    "data-element": "accordion-title",
    size: size,
    variant: variant
  }, title) : getTitle(), !buttonHeading && variant !== "subtle" && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showValidationIcon && /*#__PURE__*/_react.default.createElement(_validations.default, {
    error: error,
    warning: warning,
    info: info,
    tooltipPosition: "top",
    tabIndex: 0,
    ml: 1
  }), subTitle && size === "large" && variant === "standard" && /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionSubTitle, null, subTitle))), /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionIcon, {
    "data-element": "accordion-icon",
    type: iconType || getIconType(),
    isExpanded: isExpanded,
    iconAlign: iconAlign || (variant === "standard" ? "right" : "left")
  })), /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionContentContainer, {
    isExpanded: isExpanded,
    maxHeight: contentHeight
  }, /*#__PURE__*/_react.default.createElement(_accordion.StyledAccordionContent, {
    role: "region",
    "data-element": "accordion-content",
    id: contentId,
    "aria-labelledby": headerId,
    ref: accordionContent,
    disableContentPadding: disableContentPadding,
    variant: variant
  }, children)));
});
if (process.env.NODE_ENV !== "production") {
  Accordion.propTypes = {
    "borders": _propTypes.default.oneOf(["default", "full", "none"]),
    "buttonHeading": _propTypes.default.bool,
    "buttonWidth": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "children": _propTypes.default.node,
    "defaultExpanded": _propTypes.default.bool,
    "disableContentPadding": _propTypes.default.bool,
    "error": _propTypes.default.string,
    "expanded": _propTypes.default.bool,
    "handleKeyboardAccessibility": _propTypes.default.func,
    "headerSpacing": _propTypes.default.shape({
      "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "p": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "padding": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pl": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "px": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "py": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])
    }),
    "iconAlign": _propTypes.default.oneOf(["left", "right"]),
    "iconType": _propTypes.default.oneOf(["chevron_down_thick", "chevron_down", "dropdown"]),
    "id": _propTypes.default.string,
    "index": _propTypes.default.number,
    "info": _propTypes.default.string,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "onChange": _propTypes.default.func,
    "openTitle": _propTypes.default.string,
    "p": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "padding": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pl": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "px": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "py": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "scheme": _propTypes.default.oneOf(["transparent", "white"]),
    "size": _propTypes.default.oneOf(["large", "small"]),
    "subTitle": _propTypes.default.string,
    "title": _propTypes.default.node,
    "variant": _propTypes.default.oneOf(["standard", "subtle"]),
    "warning": _propTypes.default.string,
    "width": _propTypes.default.string
  };
}
Accordion.displayName = "Accordion";
var _default = exports.default = Accordion;