import React from "react";
import { SpaceProps } from "styled-system";
import { StyledAccordionContainerProps } from "./accordion.style";
export interface AccordionProps extends StyledAccordionContainerProps, SpaceProps {
    /** Width of the buttonHeading when it's set, defaults to 150px */
    buttonWidth?: number | string;
    /** Content of the Accordion component */
    children?: React.ReactNode;
    /** Set the default state of expansion of the Accordion if component is meant to be used as uncontrolled */
    defaultExpanded?: boolean;
    /** Disable padding for the content */
    disableContentPadding?: boolean;
    /** Sets the expansion state of the Accordion if component is meant to be used as controlled */
    expanded?: boolean;
    /** An error message to be displayed in the tooltip */
    error?: string;
    /** Styled system spacing props provided to Accordion Title */
    headerSpacing?: SpaceProps;
    id?: string;
    /** Sets icon type */
    iconType?: "chevron_down" | "chevron_down_thick" | "dropdown";
    /** Sets icon alignment */
    iconAlign?: "left" | "right";
    /** Sets accordion title */
    title: React.ReactNode;
    /** An info message to be displayed in the tooltip */
    info?: string;
    /** Callback fired when expansion state changes */
    onChange?: (event: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>, isExpanded: boolean) => void;
    /** When the Accordion is open the title can change to this */
    openTitle?: string;
    /** Sets accordion size */
    size?: "large" | "small";
    /** Sets accordion sub title */
    subTitle?: string;
    /** A warning message to be displayed in the tooltip */
    warning?: string;
}
export interface AccordionInternalProps {
    /** @ignore @private */
    handleKeyboardAccessibility?: (ev: React.KeyboardEvent<HTMLElement>, index?: number) => void;
    /** @ignore @private */
    index?: number;
}
export declare const Accordion: React.ForwardRefExoticComponent<AccordionProps & AccordionInternalProps & React.RefAttributes<HTMLDivElement>>;
export default Accordion;
