"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AccordionGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _accordion = _interopRequireDefault(require("../accordion.component"));
var _accordion2 = require("../accordion.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// typescript-to-proptypes breaks on recursive type references so it has to be an interface
// eslint-disable-next-line @typescript-eslint/no-empty-interface

const AccordionGroup = ({
  children,
  ...rest
}) => {
  const hasProperChildren = (0, _react.useMemo)(() => {
    let hasAccordionChildren = true;
    _react.default.Children.toArray(children).forEach(child => {
      if (typeof child === "string" || /*#__PURE__*/_react.default.isValidElement(child) && child.type.displayName !== "Accordion") {
        hasAccordionChildren = false;
      }
    });
    return hasAccordionChildren;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `AccordionGroup accepts only children of type \`${_accordion.default.displayName}\`.`) : (0, _invariant.default)(false) : void 0;
  const filteredChildren = (0, _react.useMemo)(() => _react.default.Children.toArray(children).filter(child => {
    return /*#__PURE__*/_react.default.isValidElement(child);
  }), [children]);
  const refs = (0, _react.useMemo)(() => filteredChildren.map(child => child.ref || /*#__PURE__*/_react.default.createRef()), [filteredChildren]);
  const focusAccordion = (0, _react.useCallback)((ev, index) => {
    ev.preventDefault();
    if (index === -1) {
      refs[refs.length - 1].current?.focus();
    } else if (index === refs.length) {
      refs[0].current?.focus();
    } else {
      refs[index].current?.focus();
    }
  }, [refs]);
  const handleKeyboardAccessibility = (0, _react.useCallback)((ev, index) => {
    if (_events.default.isUpKey(ev)) {
      focusAccordion(ev, index - 1);
    }
    if (_events.default.isDownKey(ev)) {
      focusAccordion(ev, index + 1);
    }
    if (_events.default.isHomeKey(ev)) {
      focusAccordion(ev, 0);
    }
    if (_events.default.isEndKey(ev)) {
      focusAccordion(ev, refs.length - 1);
    }
  }, [focusAccordion, refs]);
  return /*#__PURE__*/_react.default.createElement(_accordion2.StyledAccordionGroup, rest, filteredChildren.map((child, index) =>
  /*#__PURE__*/
  // casted to ReactElement as there is no overload for an FunctionComponentElement in cloneElement
  _react.default.cloneElement(child, {
    ref: refs[index],
    index,
    handleKeyboardAccessibility
  })));
};
exports.AccordionGroup = AccordionGroup;
AccordionGroup.displayName = "AccordionGroup";
var _default = exports.default = AccordionGroup;