"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeArrayKeys = exports.listFrom = exports.keyboard = exports.hoverList = exports.getDefaultValue = exports.expectConsoleOutput = exports.click = exports.childrenFrom = exports.assertStyleMatch = exports.assertKeyboardTraversal = exports.assertHoverTraversal = void 0;
Object.defineProperty(exports, "mockMatchMedia", {
  enumerable: true,
  get: function () {
    return _mockMatchMedia.mockMatchMedia;
  }
});
exports.toCSSCase = exports.testStyledSystemWidth = exports.testStyledSystemSpacing = exports.testStyledSystemPosition = exports.testStyledSystemPadding = exports.testStyledSystemMargin = exports.testStyledSystemLayout = exports.testStyledSystemHeight = exports.testStyledSystemGrid = exports.testStyledSystemFlexBox = exports.testStyledSystemColor = exports.testStyledSystemBackground = exports.simulate = exports.selectedItemOf = void 0;
var _enzyme = require("enzyme");
var _sprintfJs = require("sprintf-js");
var _baseTheme = require("../style/themes/base/base-theme.config");
var _mockMatchMedia = require("./mock-match-media");
/* eslint-disable jest/no-conditional-expect */
/* eslint-disable jest/no-identical-title */
/* eslint-disable jest/no-export */

const isUpper = char => char.toUpperCase() === char;
const humpToDash = (acc, char) => `${acc}${isUpper(char) ? `-${char.toLowerCase()}` : char}`;
const toCSSCase = str => {
  return str.split("").reduce(humpToDash, "");
};

// eslint-disable-next-line @typescript-eslint/no-explicit-any
exports.toCSSCase = toCSSCase;
const assertStyleMatch = (styleSpec, component, opts) => {
  Object.entries(styleSpec).forEach(([attr, value]) => {
    expect(component).toHaveStyleRule(toCSSCase(attr), value, opts);
  });
};
exports.assertStyleMatch = assertStyleMatch;
const makeArrayKeys = n => [...Array(n).keys()];
exports.makeArrayKeys = makeArrayKeys;
const dispatchKeyPress = code => {
  const ev = new KeyboardEvent("keydown", {
    key: code
  });
  document.dispatchEvent(ev);
};
const keys = ["ArrowUp", "ArrowDown", "ArrowRight", "ArrowLeft", "Enter", "Tab", " ", "Escape", "End", "Home", "D", "E", "P", "Z", "1"];
const keyboard = exports.keyboard = keys.reduce((acc, key) => {
  const methodName = `press${key === " " ? "Space" : key}`;
  acc[methodName] = () => dispatchKeyPress(key);
  return acc;
}, {});

// Build an object of Enzyme simulate helpers
// e.g. simulate.keydown.pressTab(target, { shiftKey: true })
// e.g. simulate.keydown.pressEscape(target)
const keydown = keys.reduce((acc, key) => {
  const methodName = `press${key === " " ? "Space" : key}`;
  acc[methodName] = (target, {
    shiftKey
  } = {
    shiftKey: false
  }) => {
    target.simulate("keydown", {
      shiftKey,
      key
    });
  };
  return acc;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
}, {});
const simulate = exports.simulate = {
  keydown
};
const listFrom = wrapper => wrapper.find("ul");
exports.listFrom = listFrom;
const childrenFrom = node => node.children();
exports.childrenFrom = childrenFrom;
const hoverList = wrapper => item => {
  childrenFrom(listFrom(wrapper)).at(item).simulate("mouseover");
};
exports.hoverList = hoverList;
const simulateEvent = eventName => wrapper => wrapper.simulate(eventName);
const click = exports.click = simulateEvent("click");
const selectedItemOf = wrapper => wrapper.state().selectedItem;
exports.selectedItemOf = selectedItemOf;
const isUnique = (val, index, self) => self.indexOf(val) === index;
const isSelectableGiven = nonSelectables => i => !nonSelectables.includes(i);
const selectedItemReducer = method => wrapper => (acc, i) => {
  method(wrapper)(i);
  return [...acc, selectedItemOf(wrapper)];
};
const arraysEqual = (arr1, arr2) => arr1.sort().join(",") === arr2.sort().join(",");
const assertCorrectTraversal = method => expect => ({
  num,
  nonSelectables = []
}) => wrapper => {
  const array = makeArrayKeys(num);
  const validIndexes = array.filter(isSelectableGiven(nonSelectables));
  const selectedItem = selectedItemOf(wrapper);
  const indexesThatWereSelected = array.reduce(selectedItemReducer(method)(wrapper), [selectedItem]).filter(isUnique);
  expect(arraysEqual(validIndexes, indexesThatWereSelected)).toBeTruthy();
};
const assertKeyboardTraversal = exports.assertKeyboardTraversal = assertCorrectTraversal(() => keyboard.pressArrowDown)(expect);
const assertHoverTraversal = exports.assertHoverTraversal = assertCorrectTraversal(wrapper => hoverList(wrapper))(expect);
const marginProps = [["m", "margin"], ["ml", "marginLeft"], ["mr", "marginRight"], ["mt", "marginTop"], ["mb", "marginBottom"], ["mx", "marginLeft"], ["mx", "marginRight"], ["my", "marginTop"], ["my", "marginBottom"]];
const paddingProps = [["p", "padding"], ["pl", "paddingLeft"], ["pr", "paddingRight"], ["pt", "paddingTop"], ["pb", "paddingBottom"], ["px", "paddingLeft"], ["px", "paddingRight"], ["py", "paddingTop"], ["py", "paddingBottom"]];
const colorProps = [["color", "color", "#CCCCCC"], ["bg", "background-color", "#FFFFFF"], ["opacity", "opacity", "0.5"]];
const widthProps = ["width", "width", "200px"];
const heightProps = ["height", "height", "200px"];
const layoutProps = [widthProps, heightProps, ["minWidth", "min-width", "120px"], ["maxWidth", "max-width", "120px"], ["minHeight", "min-height", "120px"], ["maxHeight", "max-height", "120px"], ["size", "width", "120px"], ["size", "height", "120px"], ["display", "display", "inline-block"], ["verticalAlign", "vertical-align", "baseline"], ["overflow", "overflow", "hidden"], ["overflowX", "overflow-x", "hidden"], ["overflowY", "overflow-y", "hidden"]];
const flexBoxProps = [["alignItems", "alignItems", "center"], ["alignContent", "alignContent", "center"], ["justifyItems", "justifyItems", "center"], ["justifyContent", "justifyContent", "center"], ["flexWrap", "flexWrap", "wrap"], ["flexDirection", "flexDirection", "row-reverse"], ["flex", "flex", "1"], ["flexGrow", "flexGrow", "1"], ["flexShrink", "flexShrink", "1"], ["flexBasis", "flexBasis", "100px"], ["justifySelf", "justifySelf", "center"], ["alignSelf", "alignSelf", "center"], ["order", "order", "1"]];
const gridProps = [["gridColumn", "gridColumn", "1 / span 2"], ["gridRow", "gridRow", "1 / span 2"], ["gridArea", "gridArea", "myArea"], ["gridAutoFlow", "gridAutoFlow", "column"], ["gridAutoRows", "gridAutoRows", "150px"], ["gridAutoColumns", "gridAutoColumns", "50px"], ["gridTemplateRows", "gridTemplateRows", "100px 300px"], ["gridTemplateColumns", "gridTemplateColumns", "auto auto auto auto"], ["gridTemplateAreas", "gridTemplateAreas", "myArea myArea . . ."]];
const backgroundProps = [["background", "background", "lightblue url('foo.jpg') no-repeat fixed center"], ["backgroundImage", "background-image", "url(foo.jpg)"], ["backgroundSize", "background-size", "center"], ["backgroundRepeat", "background-repeat", "no-repeat"]];
const positionProps = [["top", "0px"], ["bottom", "0px"], ["right", "0px"], ["left", "0px"], ["position", "fixed"], ["position", "sticky"], ["position", "absolute"], ["position", "static"], ["position", "relative"]];
const getDefaultValue = value => {
  const spaceArrayLength = _baseTheme.space.length - 1;
  if (value === undefined) return value;
  const parsedValue = +value;
  if (typeof value === "string" && parsedValue > spaceArrayLength) {
    return `${value}px`;
  }
  if (parsedValue <= spaceArrayLength) {
    return _baseTheme.space[parsedValue];
  }
  if (parsedValue > spaceArrayLength) {
    return `${parsedValue * 8}px`;
  }
  return value;
};
exports.getDefaultValue = getDefaultValue;
const testStyledSystemMargin = (component, defaults, styleContainer, assertOpts) => {
  describe("default props", () => {
    let wrapper;
    let StyleElement;
    beforeAll(() => {
      wrapper = (0, _enzyme.mount)(component({
        ...defaults
      }));
      StyleElement = styleContainer ? styleContainer(wrapper) : wrapper;
    });
    it("should set the correct margins", () => {
      let margin;
      let marginLeft;
      let marginRight;
      let marginTop;
      let marginBottom;
      if (defaults) {
        margin = getDefaultValue(defaults.m);
        marginLeft = getDefaultValue(defaults.ml || defaults.mx);
        marginRight = getDefaultValue(defaults.mr || defaults.mx);
        marginTop = getDefaultValue(defaults.mt || defaults.my);
        marginBottom = getDefaultValue(defaults.mb || defaults.my);
        assertStyleMatch({
          margin,
          marginLeft,
          marginRight,
          marginTop,
          marginBottom
        }, StyleElement, assertOpts);
      } else {
        expect(StyleElement).not.toHaveStyleRule("marginLeft");
        expect(StyleElement).not.toHaveStyleRule("marginRight");
        expect(StyleElement).not.toHaveStyleRule("marginTop");
        expect(StyleElement).not.toHaveStyleRule("marginBottom");
        expect(StyleElement).not.toHaveStyleRule("margin");
      }
    });
  });
  describe.each(marginProps)('when a custom spacing is specified using the "%s" styled system props', (styledSystemProp, propName) => {
    it(`then that ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: 2
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      assertStyleMatch({
        [propName]: "var(--spacing200)"
      }, styleContainer ? styleContainer(wrapper) : wrapper, assertOpts);
    });
  });
};
exports.testStyledSystemMargin = testStyledSystemMargin;
const testStyledSystemPadding = (component, defaults, styleContainer, assertOpts) => {
  describe("default props", () => {
    let wrapper;
    let StyleElement;
    beforeAll(() => {
      wrapper = (0, _enzyme.mount)(component({
        ...defaults
      }));
      StyleElement = styleContainer ? styleContainer(wrapper) : wrapper;
    });
    it("should set the correct paddings", () => {
      let padding;
      let paddingLeft;
      let paddingRight;
      let paddingTop;
      let paddingBottom;
      if (defaults) {
        padding = getDefaultValue(defaults.p);
        paddingLeft = getDefaultValue(defaults.pl || defaults.px);
        paddingRight = getDefaultValue(defaults.pr || defaults.px);
        paddingTop = getDefaultValue(defaults.pt || defaults.py);
        paddingBottom = getDefaultValue(defaults.pb || defaults.py);
        assertStyleMatch({
          padding,
          paddingLeft,
          paddingRight,
          paddingTop,
          paddingBottom
        }, StyleElement, assertOpts);
      } else {
        expect(StyleElement).not.toHaveStyleRule("paddingLeft");
        expect(StyleElement).not.toHaveStyleRule("paddingRight");
        expect(StyleElement).not.toHaveStyleRule("paddingTop");
        expect(StyleElement).not.toHaveStyleRule("paddingBottom");
        expect(StyleElement).not.toHaveStyleRule("padding");
      }
    });
  });
  describe.each(paddingProps)('when a custom spacing is specified using the "%s" styled system props', (styledSystemProp, propName) => {
    it(`then that ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: 2
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      assertStyleMatch({
        [propName]: "var(--spacing200)"
      }, styleContainer ? styleContainer(wrapper) : wrapper, assertOpts);
    });
  });
};
exports.testStyledSystemPadding = testStyledSystemPadding;
const testStyledSystemSpacing = (component, defaults, styleContainer, assertOpts) => {
  testStyledSystemMargin(component, defaults, styleContainer, assertOpts);
  testStyledSystemPadding(component, defaults, styleContainer, assertOpts);
};
exports.testStyledSystemSpacing = testStyledSystemSpacing;
const testStyledSystemColor = (component, styleContainer) => {
  describe.each(colorProps)('when a prop is specified using the "%s" styled system props', (styledSystemProp, propName, value) => {
    it(`then ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      const StyleElement = styleContainer ? styleContainer(wrapper) : wrapper;
      // Some props need to have camelcase so used toHaveStyleRule rather than assertStyleMatch
      expect(StyleElement).toHaveStyleRule(propName, value);
    });
  });
};
exports.testStyledSystemColor = testStyledSystemColor;
const testStyledSystemWidth = (component, styleContainer) => {
  describe("when a width prop is specified using styled system props", () => {
    it("then width should have been set correctly", () => {
      const [styledSystemProp, propName, value] = widthProps;
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      const StyleElement = styleContainer ? styleContainer(wrapper) : wrapper;
      expect(StyleElement).toHaveStyleRule(propName, value);
    });
  });
};
exports.testStyledSystemWidth = testStyledSystemWidth;
const testStyledSystemHeight = (component, styleContainer) => {
  describe("when a height prop is specified using styled system props", () => {
    it("then height should have been set correctly", () => {
      const [styledSystemProp, propName, value] = heightProps;
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      const StyleElement = styleContainer ? styleContainer(wrapper) : wrapper;
      expect(StyleElement).toHaveStyleRule(propName, value);
    });
  });
};
exports.testStyledSystemHeight = testStyledSystemHeight;
const testStyledSystemLayout = (component, styleContainer) => {
  describe.each(layoutProps)('when a prop is specified using the "%s" styled system props', (styledSystemProp, propName, value) => {
    it(`then ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      const StyleElement = styleContainer ? styleContainer(wrapper) : wrapper;
      // Some props need to have camelcase so used toHaveStyleRule rather than assertStyleMatch
      expect(StyleElement).toHaveStyleRule(propName, value);
    });
  });
};
exports.testStyledSystemLayout = testStyledSystemLayout;
const testStyledSystemFlexBox = (component, styleContainer) => {
  describe.each(flexBoxProps)('when a prop is specified using the "%s" styled system props', (styledSystemProp, propName, value) => {
    it(`then ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component(props));
      assertStyleMatch({
        [propName]: value
      }, styleContainer ? styleContainer(wrapper) : wrapper);
    });
  });
};
exports.testStyledSystemFlexBox = testStyledSystemFlexBox;
const testStyledSystemGrid = (component, styleContainer) => {
  describe.each(gridProps)('when a prop is specified using the "%s" styled system props', (styledSystemProp, propName, value) => {
    it(`then ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component(props));
      assertStyleMatch({
        [propName]: value
      }, styleContainer ? styleContainer(wrapper) : wrapper);
    });
  });
};
exports.testStyledSystemGrid = testStyledSystemGrid;
const testStyledSystemBackground = (component, styleContainer) => {
  describe.each(backgroundProps)('when a prop is specified using the "%s" styled system props', (styledSystemProp, propName, value) => {
    it(`then ${propName} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      assertStyleMatch({
        [styledSystemProp]: value
      }, styleContainer ? styleContainer(wrapper) : wrapper);
    });
  });
};
exports.testStyledSystemBackground = testStyledSystemBackground;
const testStyledSystemPosition = (component, styleContainer) => {
  describe.each(positionProps)('when a prop is specified using the "%s" styled system props', (styledSystemProp, value) => {
    it(`then ${styledSystemProp} should have been set correctly`, () => {
      const props = {
        [styledSystemProp]: value
      };
      const wrapper = (0, _enzyme.mount)(component({
        ...props
      }));
      assertStyleMatch({
        [styledSystemProp]: value
      }, styleContainer ? styleContainer(wrapper) : wrapper);
    });
  });
};

// this util will catch that a console output occurred without polluting the output when running the unit tests
exports.testStyledSystemPosition = testStyledSystemPosition;
const expectConsoleOutput = (message, type = "error") => {
  if (!message) {
    throw new Error(`no ${type} message provided`);
  }
  expect.assertions(1);
  const consoleType = global.console[type];
  let consoleArgs;
  jest.spyOn(global.console, type).mockImplementation((...args) => {
    if (!args.length) return;
    const msg = args.join(" ");
    const params = args.slice(1, args.length);
    if ((0, _sprintfJs.sprintf)(msg, ...params).includes(message)) {
      consoleArgs = args;
      return;
    }
    consoleType(...args);
  });
  return () => {
    if (consoleArgs) {
      // eslint-disable-next-line no-console
      expect(console[type]).toHaveBeenCalledWith(...consoleArgs);
    }
    global.console[type] = consoleType;
  };
};
exports.expectConsoleOutput = expectConsoleOutput;