"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simulateDropdownEvent = simulateDropdownEvent;
exports.simulateSelectTextboxEvent = simulateSelectTextboxEvent;
var _testUtils = require("react-dom/test-utils");
var _jsdomTestingMocks = require("jsdom-testing-mocks");
var _selectList = require("../components/select/select-list/select-list.style");
const resizeObserver = (0, _jsdomTestingMocks.mockResizeObserver)();
function simulateSelectTextboxEvent(container, eventType,
// eslint-disable-next-line @typescript-eslint/no-explicit-any
...eventArgs) {
  const selectText = container.find('input[type="text"]').first();
  selectText.simulate(eventType, ...eventArgs);
  const selectList = container.find(_selectList.StyledSelectListContainer).getDOMNode();
  // need to manually trigger a resize to make react-virtual realise that child options should be rendered
  (0, _testUtils.act)(() => {
    resizeObserver.mockElementSize(selectList, {
      contentBoxSize: {
        inlineSize: 500,
        blockSize: 180
      }
    });
    resizeObserver.resize();
  });
  if (eventType === "focus") jest.runOnlyPendingTimers();
  container.update();
}
function simulateDropdownEvent(container, eventType) {
  const dropdown = container.find('[type="dropdown"]').first();
  dropdown.simulate(eventType);
  const selectList = container.find(_selectList.StyledSelectListContainer).getDOMNode();
  // need to manually trigger a resize to make react-virtual realise that child options should be rendered
  (0, _testUtils.act)(() => {
    resizeObserver.mockElementSize(selectList, {
      contentBoxSize: {
        inlineSize: 500,
        blockSize: 180
      }
    });
    resizeObserver.resize();
  });
  container.update();
}