"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const setupResizeObserverMock = () => {
  if (!window) {
    return;
  }
  window.ResizeObserver = window.ResizeObserver || jest.fn().mockImplementation(callback => {
    let hasCalledCallback = false;
    const observer = {
      disconnect: jest.fn(),
      // observe mock needs to actually call the callback straight away, as this is what a real ResizeObserver does
      // and this behaviour is needed for the FixedNavigationBarContextProvider to work properly.
      // Note that we must only call the callback once per ResizeObserver instance, to avoid stack overflows in
      // react-virtual.
      observe: jest.fn(target => {
        if (!hasCalledCallback) {
          hasCalledCallback = true;
          callback([{
            target
          }], observer);
        }
      }),
      unobserve: jest.fn()
    };
    return observer;
  });
};
var _default = exports.default = setupResizeObserverMock;