"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupMatchMediaMock = exports.mockMatchMedia = void 0;
let mocked = false;
let _matches = false;
const removeEventListener = jest.fn();
const setupMatchMediaMock = () => {
  if (!global.window) {
    return;
  }
  const noop = () => {};
  Object.defineProperty(global.window, "matchMedia", {
    writable: true,
    value: query => ({
      matches: _matches,
      media: query,
      onchange: null,
      addEventListener: noop,
      removeEventListener,
      dispatchEvent: noop
    })
  });
  mocked = true;
};
exports.setupMatchMediaMock = setupMatchMediaMock;
const mockMatchMedia = matches => {
  if (!mocked) {
    throw new Error("window.matchMedia has not been mocked. Did you call setupMatchMediaMock()?");
  }
  _matches = matches;
  return {
    removeEventListener
  };
};
exports.mockMatchMedia = mockMatchMedia;