"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const getDOMRect = (width, height) => ({
  width,
  height,
  top: 0,
  left: 0,
  bottom: 0,
  right: 0,
  x: 0,
  y: 0,
  toJSON: () => {}
});
const mockDOMRect = (width, height, elementIdentifier) => {
  Element.prototype.getBoundingClientRect = jest.fn(function () {
    if (this.getAttribute("data-component") === elementIdentifier) {
      return getDOMRect(width, height);
    }
    return getDOMRect(0, 0);
  });
};
var _default = exports.default = mockDOMRect;